<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveWall\Table\WallTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveWall
{

	/**
	 * render frontend wall
	 *
	 * @param WallTable[]     $rows
	 * @param cbPageNav       $pageNav
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showWall( $rows, $pageNav, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$messageLimit						=	( ! $isModerator ? $plugin->params->getInt( 'groups_wall_character_limit', 0 ) : 0 );

		$js									=	"$( '.gjGroupWallNew:not(.gjGroupWallNewOpen)' ).on( 'click', function() {"
											.		"var size = $( this ).find( 'textarea' ).data( 'cbgjwall-input-size' );"
											.		"if ( ! size ) {"
											.			"size = 3;"
											.		"}"
											.		"$( this ).find( '.gjGroupWallNewFooter,.gjGroupWallInputGroup' ).removeClass( 'hidden' );"
											.		"$( this ).addClass( 'gjGroupWallNewOpen' );"
											.		"$( this ).find( 'textarea' ).attr( 'rows', size ).autosize({"
											.			"append: '',"
											.			"resizeDelay: 0,"
											.			"placeholder: false"
											.		"});"
											.	"});"
											.	"$( '.gjGroupWall .cbMoreLess' ).cbmoreless();";

		if ( $messageLimit ) {
			$js								.=	"$( '.gjGroupWallNew textarea' ).on( 'keyup input change', function() {"
											.		"var inputLength = $( this ).val().length;"
											.		"if ( inputLength > " . (int) $messageLimit . " ) {"
											.			"$( this ).val( $( this ).val().substr( 0, " . (int) $messageLimit . " ) );"
											.		"} else {"
											.			"$( this ).closest( '.gjGroupWallNew' ).find( '.gjGroupWallLimitCurrent' ).html( $( this ).val().length );"
											.		"}"
											.	"});";
		}

		$_CB_framework->outputCbJQuery( $js, array( 'cbmoreless', 'autosize' ) );

		cbValidator::loadValidation();
		initToolTip();

		$isOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus							=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'wall' );
		$showReplies						=	$plugin->params->getInt( 'groups_wall_replies', 1 );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayWall', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupWall">'
											.		'<div class="gjGroupWallRows">';

		if ( $canCreate ) {
			$return							.=			'<div class="card mb-3 gjGroupWallRow gjGroupWallNew">'
											.				'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'save' ) ) . '" method="post" name="gjGroupWallFormNew" id="gjGroupWallFormNew" class="m-0 gjGroupWallForm cbValidation">'
											.					'<div class="card-body p-0 gjGroupWallNewBody">'
											.						'<div class="cb_form_line gjGroupWallInputGroup gjGroupWallInputMessageContainer">'
											.							'<textarea name="post" rows="1" class="form-control shadow-none border-0 gjGroupWallInput gjGroupWallInputMessage required" placeholder="' . htmlspecialchars( CBTxt::T( 'Have a post to share?' ) ) . '"' . ( $messageLimit ? ' maxlength="' . (int) $messageLimit . '"' : null ) . ' data-cbgjwall-input-size="3"></textarea>'
											.						'</div>'
											.					'</div>'
											.					'<div class="card-footer p-2 text-right gjGroupWallNewFooter hidden">';

			if ( $messageLimit ) {
				$return						.=						'<div class="badge badge-secondary font-weight-normal align-bottom gjGroupWallLimit">'
											.							'<span class="gjGroupWallLimitCurrent">0</span> / <span class="gjGroupWallLimitMax">' . (int) $messageLimit . '</span>'
											.						'</div> ';
			}

			$return							.=						'<button type="submit" class="btn btn-primary btn-sm btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . CBTxt::T( 'Post' ) . '</button>'
											.					'</div>'
											.					'<input type="hidden" name="group" value="' . $group->getInt( 'id', 0 ) . '" />'
											.					cbGetSpoofInputTag( 'plugin' )
											.				'</form>'
											.			'</div>';
		}

		if ( $rows ) {
			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner				=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$menu						=	array();

				$integrations				=	$_PLUGINS->trigger( 'gj_onDisplayWall', array( &$row, &$menu, $group, $user ) );

				$cbUser						=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
				$replies					=	( $showReplies ? $plugin->showReplies( $row, $group, $user ) : null );

				$return						.=			'<div class="card mb-3 gjGroupWallRow">'
											.				'<div class="media card-header p-0 pt-2 pl-2 pr-2 bg-transparent border-0 gjGroupWallRowHeader">'
											.					'<div class="media-left gjGroupWallRowAvatar">'
											.						$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
											.					'</div>'
											.					'<div class="media-body pl-2 pr-5 gjGroupWallRowDetails">'
											.						'<div class="text-muted gjGroupWallRowAuthor">'
											.							'<strong>' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong>'
											.						'</div>'
											.						'<div class="text-small text-muted gjGroupWallRowDate">'
											.							cbFormatDate( $row->getString( 'date' ), true, 'timeago' );

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'wall', 1 ) === 2 ) ) ) {
					$return					.=							' <span class="fa fa-clock-o text-warning gjGroupPendingIcon" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span>';
				}

				$return						.=						'</div>'
											.					'</div>'
											.				'</div>'
											.				'<div class="card-body p-0 gjGroupWallRowBody">'
											.					'<div class="m-2 cbMoreLess gjGroupWallRowPost">'
											.						'<div class="cbMoreLessContent">'
											.							$row->post()
											.						'</div>'
											.						'<div class="fade-edge cbMoreLessOpen hidden">'
											.							'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
											.						'</div>'
											.					'</div>'
											.				'</div>';

				if ( $replies || ( is_array( $integrations ) && $integrations ) ) {
					$return					.=				'<div class="card-footer p-0 gjGroupWallRowFooter">';

					if ( $replies ) {
						$return				.=					'<div class="m-2 gjGroupWallReplies">'
											.						$replies
											.					'</div>';
					}

					if ( is_array( $integrations ) && $integrations ) {
						$return				.=					'<div class="m-2 gjGroupWallIntegrations">'
											.						implode( '', $integrations )
											.					'</div>';
					}

					$return					.=				'</div>';
				}

				if ( $isModOrOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjWallMenuItems">';

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'wall', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Post?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Post?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'wall', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$return					.=				'<div class="pt-2 text-right gjGroupWallMenu">'
											.					cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu gjGroupWallMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' )
											.				'</div>';
				}

				$return						.=			'</div>';
			}
		} else {
			$return							.=			'<div class="gjGroupWallRow gjGroupWallEmpty">'
											.				CBTxt::T( 'This group currently has no posts.' )
											.			'</div>';
		}

		$return								.=		'</div>';

		if ( $plugin->params->getInt( 'groups_wall_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
			$return							.=		'<div class="mt-3 gjGroupWallPaging">'
											.			$pageNav->getListLinks()
											.		'</div>';
		}

		$return								.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayWall', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}