<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Core\AutoLoader;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework, $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Code/(.+)%i', __DIR__ . '/library/$1.php' );

$_CB_framework->addJQueryPlugin( 'cbcodeautocomplete', '/components/com_comprofiler/plugin/user/plug_cbcodefield/js/jquery.cbcodeautocomplete.js', array( -1 => array( 'ui-all' ) ) );

$_PLUGINS->registerFunction( 'onBeforefieldClass', 'getResponse', '\CB\Plugin\Code\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforegetFieldRow', 'getDisplay', '\CB\Plugin\Code\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforeprepareFieldDataSave', 'checkValidation', '\CB\Plugin\Code\Trigger\FieldTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array(	'code'					=>	'\CB\Plugin\Code\Field\CodeField',
											'codemulticheckbox'		=>	'\CB\Plugin\Code\Field\CodeSelectField',
											'codemultiselect'		=>	'\CB\Plugin\Code\Field\CodeSelectField',
											'codeselect'			=>	'\CB\Plugin\Code\Field\CodeSelectField',
											'coderadio'				=>	'\CB\Plugin\Code\Field\CodeSelectField',
											'codetag'				=>	'\CB\Plugin\Code\Field\CodeSelectField'
										));