<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Language\CBTxt;
use CB\Plugin\FieldGroups\CBFieldGroups;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var array        $fieldGroups
 * @var string       $fieldName
 * @var string       $repeatLabel
 * @var bool         $repeatOrdering
 * @var bool         $repeatCount
 * @var int          $repeatMax
 * @var array        $rows
 * @var int          $row
 * @var array        $titles
 * @var array        $descriptions
 * @var array        $fields
 * @var FieldTable[] $groupedFields
 *
 * @var FieldTable   $field
 * @var UserTable    $user
 * @var string       $output
 * @var string       $reason
 * @var int          $list_compare_types
 */
?>
<div class="row no-gutters border rounded mw-100 cbRepeatRow">
	<?php if ( $repeatOrdering ) { ?>
	<div class="mt-2 mt-sm-0 ml-2 mr-2 mr-sm-0 col-12 col-sm flex-grow-0 flex-shrink-1 align-self-sm-center cbRepeatRowSort">
		<div class="btn btn-sm btn-secondary d-block d-sm-inline-block cbRepeatRowMove" title="<?php echo htmlspecialchars( CBTxt::T( 'Click and drag to move this row.' ) ); ?>"><span class="fa fa-sort"></span></div>
		<input type="hidden" name="<?php echo CBFieldGroups::getGroupedName( $fieldName, $row, 'index' ); ?>" value="<?php echo (int) $row; ?>" />
	</div>
	<?php } ?>
	<div class="mt-2 mt-sm-3 ml-2 mr-2 col-12 col-sm flex-grow-1 flex-shrink-1 cbRepeatRowParams">
		<?php echo implode( '', $fields ); ?>
	</div>
	<div class="mb-2 mb-sm-0 ml-2 ml-sm-0 mr-2 col-12 col-sm flex-grow-0 flex-shrink-1 align-self-sm-center cbRepeatRowIncrement">
		<div class="btn btn-sm btn-danger d-block d-sm-inline-block cbRepeatRowRemove" title="<?php echo htmlspecialchars( CBTxt::T( 'Click to remove this row.' ) ); ?>"><span class="fa fa-minus"></span></div>
	</div>
</div>
