<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Application\Application;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CBLib\Registry\GetterInterface;
use CB\Plugin\AntiSpam\CBAntiSpam;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/AntiSpam/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\AntiSpam\Trigger\AdminTrigger' );

$_PLUGINS->registerFunction( 'onPrepareMenus', 'displayMenu','\CB\Plugin\AntiSpam\Trigger\MenuTrigger' );

$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deleteUserData', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );

// Login
$_PLUGINS->registerFunction( 'onAfterLoginForm', 'displayCaptcha', '\CB\Plugin\AntiSpam\Trigger\LoginTrigger' );
$_PLUGINS->registerFunction( 'onBeforeLogin', 'beforeLogin', '\CB\Plugin\AntiSpam\Trigger\LoginTrigger' );
$_PLUGINS->registerFunction( 'onDuringLogin', 'duringLogin', '\CB\Plugin\AntiSpam\Trigger\LoginTrigger' );
$_PLUGINS->registerFunction( 'onAfterLogin', 'afterLogin', '\CB\Plugin\AntiSpam\Trigger\LoginTrigger' );

// Forgot Login
$_PLUGINS->registerFunction( 'onLostPassForm', 'displayCaptcha', '\CB\Plugin\AntiSpam\Trigger\ForgotLoginTrigger' );
$_PLUGINS->registerFunction( 'onStartNewPassword', 'beforeForgotLogin', '\CB\Plugin\AntiSpam\Trigger\ForgotLoginTrigger' );
$_PLUGINS->registerFunction( 'onAfterUsernameReminder', 'afterForgotLoginUsername', '\CB\Plugin\AntiSpam\Trigger\ForgotLoginTrigger' );
$_PLUGINS->registerFunction( 'onAfterPasswordReminder', 'afterForgotLoginPassword', '\CB\Plugin\AntiSpam\Trigger\ForgotLoginTrigger' );

// Registration
$_PLUGINS->registerFunction( 'onStartSaveUserRegistration', 'beforeRegistration', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onBeforeUserRegistration', 'duringRegistration', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterSaveUserRegistration', 'afterRegistration', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterEmailUserForm', 'displayEmailCaptcha', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onBeforeEmailUser', 'validateEmailCaptcha', '\CB\Plugin\AntiSpam\Trigger\UserTrigger' );

// Legacy Captcha
$_PLUGINS->registerFunction( 'onGetCaptchaHtmlElements', 'displayCaptcha', '\CB\Plugin\AntiSpam\Trigger\CaptchaTrigger' );
$_PLUGINS->registerFunction( 'onCheckCaptchaHtmlElements', 'validateCaptcha', '\CB\Plugin\AntiSpam\Trigger\CaptchaTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array(	'antispam_ipaddress'	=>	'\CB\Plugin\AntiSpam\Field\IPAddressField',
											'antispam_captcha'		=>	'\CB\Plugin\AntiSpam\Field\CaptchaField'
										));

class cbantispamTab extends cbTabHandler
{

	/**
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param int       $ui
	 * @return null|string
	 */
	public function getDisplayTab( $tab, $user, $ui )
	{
		global $_CB_framework, $_CB_database;

		if ( ( ! Application::MyUser()->isGlobalModerator() ) || Application::User( $user->get( 'id', 0, GetterInterface::INT ) )->isGlobalModerator() ) {
			return null;
		}

		if ( ! ( $tab->params instanceof ParamsInterface ) ) {
			$tab->params			=	new Registry( $tab->params );
		}

		$blocksEnabled				=	( $this->params->get( 'general_block', true, GetterInterface::BOOLEAN ) && $tab->params->get( 'tab_block', ( $this instanceof cbantispamTabBlocks ? true : false ), GetterInterface::BOOLEAN ) );
		$whitelistsEnabled			=	( $this->params->get( 'general_whitelist', true, GetterInterface::BOOLEAN ) && $tab->params->get( 'tab_whitelist', ( $this instanceof cbantispamTabWhitelists ? true : false ), GetterInterface::BOOLEAN ) );
		$attemptsEnabled			=	( $this->params->get( 'general_attempts', true, GetterInterface::BOOLEAN ) && $tab->params->get( 'tab_attempts', ( $this instanceof cbantispamTabAttempts ? true : false ), GetterInterface::BOOLEAN ) );
		$logsEnabled				=	( $this->params->get( 'general_log', true, GetterInterface::BOOLEAN ) && $tab->params->get( 'tab_logs', ( $this instanceof cbantispamTabLog ? true : false ), GetterInterface::BOOLEAN ) );

		if ( ( ! $blocksEnabled ) && ( ! $whitelistsEnabled ) && ( ! $attemptsEnabled ) && ( ! $logsEnabled ) ) {
			return null;
		}

		$tabPrefix				=	'tab_' . $tab->get( 'tabid', 0, GetterInterface::INT ) . '_';
		/** @noinspection PhpUnusedLocalVariableInspection */
		$viewer					=	CBuser::getMyUserDataInstance();

		outputCbJs();
		outputCbTemplate();
		initToolTip();

		$ipAddress				=	CBAntiSpam::getUserIP( $user );
		$emailDomain			=	CBAntiSpam::getEmailDomain( $user );
		/** @noinspection PhpUnusedLocalVariableInspection */
		$returnUrl				=	base64_encode( $_CB_framework->userProfileUrl( $user->get( 'id', 0, GetterInterface::INT ), false, $tab->get( 'tabid', 0, GetterInterface::INT ) ) );

		// Construct the type filter where statements to apply to block and whitelist views
		$where					=	array();

		if ( $blocksEnabled || $whitelistsEnabled ) {
			$where[]			.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'user' )
								.	" AND " . $_CB_database->NameQuote( 'value' ) . " = " . $user->get( 'id', 0, GetterInterface::INT ) . " )";

			$where[]			.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'email' )
								.	" AND " . $_CB_database->NameQuote( 'value' ) . " = " . $_CB_database->Quote( $user->get( 'email', null, GetterInterface::STRING ) ) . " )";

			$where[]			.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'email_partial' )
								.	" AND " . $_CB_database->Quote( $user->get( 'email', null, GetterInterface::STRING ) ) . " LIKE " . $_CB_database->NameQuote( 'value' ) . " )";

			if ( $emailDomain ) {
				$where[]		.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'domain' )
								.	" AND " . $_CB_database->NameQuote( 'value' ) . " = " . $_CB_database->Quote( $emailDomain ) . " )";

				$where[]		.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'domain_partial' )
								.	" AND " . $_CB_database->Quote( $emailDomain ) . " LIKE " . $_CB_database->NameQuote( 'value' ) . " )";
			}

			if ( $ipAddress ) {
				$where[]		.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'ip' )
								.	" AND " . $_CB_database->NameQuote( 'value' ) . " = " . $_CB_database->Quote( $ipAddress ) . " )";

				$where[]		.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'ip_partial' )
								.	" AND " . $_CB_database->Quote( $ipAddress ) . " LIKE " . $_CB_database->NameQuote( 'value' ) . " )";

				$where[]		.=	"( " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'ip_range' )
								.	" AND ( INET_ATON( " . $_CB_database->Quote( $ipAddress ) . " ) BETWEEN INET_ATON( SUBSTRING_INDEX( " . $_CB_database->NameQuote( 'value' ) . ", ':', 1 ) ) AND INET_ATON( SUBSTRING_INDEX( " . $_CB_database->NameQuote( 'value' ) . ", ':', -1 ) ) ) )";
			}
		}

		$blocks					=	null;

		if ( $blocksEnabled ) {
			$blocksPrefix		=	$tabPrefix . 'blocks_';
			$limit				=	$tab->params->get( 'tab_limit', 15, GetterInterface::INT );
			$limitstart			=	$_CB_framework->getUserStateFromRequest( $blocksPrefix . 'limitstart{com_comprofiler}', $blocksPrefix . 'limitstart' );

			$query				=	"SELECT COUNT(*)"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_block' )
								.	"\n WHERE " . implode( " OR ", $where );
			$_CB_database->setQuery( $query );
			$total				=	$_CB_database->loadResult();

			if ( $total <= $limitstart ) {
				$limitstart		=	0;
			}

			$pageNav			=	new cbPageNav( $total, $limitstart, $limit );

			$pageNav->setInputNamePrefix( $blocksPrefix );

			/** @noinspection PhpUnusedLocalVariableInspection */
			$rows				=	array();

			if ( $total ) {
				$query			=	"SELECT *"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_block' )
								.	"\n WHERE " . implode( " OR ", $where )
								.	"\n ORDER BY " . $_CB_database->NameQuote( 'id' ) . " ASC";
				if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) ) {
					$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
				} else {
					$_CB_database->setQuery( $query );
				}
				/** @noinspection PhpUnusedLocalVariableInspection */
				$rows			=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AntiSpam\Table\BlockTable', array( $_CB_database ) );
			}

			ob_start();
			require CBAntiSpam::getTemplate( null, 'blocks' );
			$blocks				=	ob_get_contents();
			ob_end_clean();
		}

		$whitelists				=	null;

		if ( $whitelistsEnabled ) {
			$whitelistsPrefix	=	$tabPrefix . 'whitelists_';
			$limit				=	$tab->params->get( 'tab_limit', 15, GetterInterface::INT );
			$limitstart			=	$_CB_framework->getUserStateFromRequest( $whitelistsPrefix . 'limitstart{com_comprofiler}', $whitelistsPrefix . 'limitstart' );

			$query				=	"SELECT COUNT(*)"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_whitelist' )
								.	"\n WHERE " . implode( " OR ", $where );
			$_CB_database->setQuery( $query );
			$total				=	$_CB_database->loadResult();

			if ( $total <= $limitstart ) {
				$limitstart		=	0;
			}

			$pageNav			=	new cbPageNav( $total, $limitstart, $limit );

			$pageNav->setInputNamePrefix( $whitelistsPrefix );

			/** @noinspection PhpUnusedLocalVariableInspection */
			$rows				=	array();

			if ( $total ) {
				$query			=	"SELECT *"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_whitelist' )
								.	"\n WHERE " . implode( " OR ", $where )
								.	"\n ORDER BY " . $_CB_database->NameQuote( 'id' ) . " ASC";
				if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) ) {
					$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
				} else {
					$_CB_database->setQuery( $query );
				}
				/** @noinspection PhpUnusedLocalVariableInspection */
				$rows			=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AntiSpam\Table\WhitelistTable', array( $_CB_database ) );
			}

			ob_start();
			require CBAntiSpam::getTemplate( null, 'whitelists' );
			$whitelists			=	ob_get_contents();
			ob_end_clean();
		}

		$attempts				=	null;

		if ( $attemptsEnabled ) {
			$attemptsPrefix		=	$tabPrefix . 'attempts_';
			$limit				=	$tab->params->get( 'tab_limit', 15, GetterInterface::INT );
			$limitstart			=	$_CB_framework->getUserStateFromRequest( $attemptsPrefix . 'limitstart{com_comprofiler}', $attemptsPrefix . 'limitstart' );
			$total				=	0;

			if ( $ipAddress ) {
				$query			=	"SELECT COUNT(*)"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_attempts' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'ip_address' ) . " = " . $_CB_database->Quote( $ipAddress );
				$_CB_database->setQuery( $query );
				$total			=	$_CB_database->loadResult();
			}

			if ( $total <= $limitstart ) {
				$limitstart		=	0;
			}

			$pageNav			=	new cbPageNav( $total, $limitstart, $limit );

			$pageNav->setInputNamePrefix( $attemptsPrefix );

			/** @noinspection PhpUnusedLocalVariableInspection */
			$rows				=	array();

			if ( $ipAddress && $total ) {
				$query			=	"SELECT *"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_attempts' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'ip_address' ) . " = " . $_CB_database->Quote( $ipAddress )
								.	"\n ORDER BY " . $_CB_database->NameQuote( 'date' ) . " DESC";
				if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) ) {
					$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
				} else {
					$_CB_database->setQuery( $query );
				}
				/** @noinspection PhpUnusedLocalVariableInspection */
				$rows			=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AntiSpam\Table\AttemptTable', array( $_CB_database ) );
			}

			ob_start();
			require CBAntiSpam::getTemplate( null, 'attempts' );
			$attempts			=	ob_get_contents();
			ob_end_clean();
		}

		$logs					=	null;

		if ( $logsEnabled ) {
			$logsPrefix			=	$tabPrefix . 'logs_';
			$limit				=	$tab->params->get( 'tab_limit', 15, GetterInterface::INT );
			$limitstart			=	$_CB_framework->getUserStateFromRequest( $logsPrefix . 'limitstart{com_comprofiler}', $logsPrefix . 'limitstart' );

			$query				=	"SELECT COUNT(*)"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_log' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
			$_CB_database->setQuery( $query );
			$total				=	$_CB_database->loadResult();

			if ( $total <= $limitstart ) {
				$limitstart		=	0;
			}

			$pageNav			=	new cbPageNav( $total, $limitstart, $limit );

			$pageNav->setInputNamePrefix( $logsPrefix );

			/** @noinspection PhpUnusedLocalVariableInspection */
			$rows				=	array();

			if ( $total ) {
				$query			=	"SELECT *"
								.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_antispam_log' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT )
								.	"\n ORDER BY " . $_CB_database->NameQuote( 'date' ) . " DESC";
				if ( $tab->params->get( 'tab_paging', true, GetterInterface::BOOLEAN ) ) {
					$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
				} else {
					$_CB_database->setQuery( $query );
				}
				/** @noinspection PhpUnusedLocalVariableInspection */
				$rows			=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\AntiSpam\Table\LogTable', array( $_CB_database ) );
			}

			ob_start();
			require CBAntiSpam::getTemplate( null, 'logs' );
			$logs				=	ob_get_contents();
			ob_end_clean();
		}

		$tabs					=	new cbTabs( 1, 1 );
		$count					=	0;

		if ( $blocks ) {
			$count++;
		}

		if ( $whitelists ) {
			$count++;
		}

		if ( $attempts ) {
			$count++;
		}

		if ( $logs ) {
			$count++;
		}

		if ( ! $count ) {
			return null;
		}

		$tabbed					=	( $count > 1 );
		$class					=	$this->params->get( 'general_class', null );
		$return					=	'<div class="cbAntiSpam' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">';

		if ( $tabbed ) {
			$return				.=		$tabs->startPane( 'blocksTabs' );
		}

		if ( $blocks ) {
			if ( $tabbed ) {
				$return			.=			$tabs->startTab( null, htmlspecialchars( CBTxt::T( 'TAB_BLOCKS', 'Blocks' ) ), 'blocksTabBlocks' )
								.				$blocks
								.			$tabs->endTab();
			} else {
				$return			.=		$blocks;
			}
		}

		if ( $whitelists ) {
			if ( $tabbed ) {
				$return			.=			$tabs->startTab( null, htmlspecialchars( CBTxt::T( 'TAB_WHITELISTS', 'Whitelists' ) ), 'blocksTabWhitelists' )
								.				$whitelists
								.			$tabs->endTab();
			} else {
				$return			.=		$whitelists;
			}
		}

		if ( $attempts ) {
			if ( $tabbed ) {
				$return			.=			$tabs->startTab( null, htmlspecialchars( CBTxt::T( 'TAB_ATTEMPTS', 'Attempts' ) ), 'blocksTabAttempts' )
								.				$attempts
								.			$tabs->endTab();
			} else {
				$return			.=		$attempts;
			}
		}

		if ( $logs ) {
			if ( $tabbed ) {
				$return			.=			$tabs->startTab( null, htmlspecialchars( CBTxt::T( 'TAB_LOGS', 'Logs' ) ), 'blocksTabLogs' )
								.				$logs
								.			$tabs->endTab();
			} else {
				$return			.=		$logs;
			}
		}

		if ( $tabbed ) {
			$return				.=		$tabs->endPane();
		}

		$return					.=	'</div>';

		return $return;
	}
}

class cbantispamTabBlocks extends cbantispamTab {}

class cbantispamTabWhitelists extends cbantispamTab {}

class cbantispamTabAttempts extends cbantispamTab {}

class cbantispamTabLog extends cbantispamTab {}