<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Language\CBTxt;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;

defined( '_JEXEC' ) or die;

class plgContentcbreplacerbot extends CMSPlugin
{
	/** @var string[]  */
	protected $replacersFromRegexp		=	[];
	/** @var string[]  */
	protected $replacersToRegexp		=	[];
	/** @var string[]  */
	protected $replacersFromCase		=	[];
	/** @var string[]  */
	protected $replacersToCase			=	[];
	/** @var string[]  */
	protected $replacersFrom			=	[];
	/** @var string[]  */
	protected $replacersTo				=	[];

	/**
	 * Loads in CB API
	 *
	 * @return bool
	 */
	private function loadCB(): bool
	{
		static $CB_loaded	=	0;

		if ( ! $CB_loaded++ ) {
			if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
				return false;
			}

			include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

			cbimport( 'cb.html' );
			cbimport( 'language.front' );
		}

		return true;
	}

	/**
	 * Gets and prepares the replacers
	 */
	private function getReplacers(): void
	{
		if ( ( ! $this->replacersFromRegexp ) && ( ! $this->replacersFromCase ) && ( ! $this->replacersFrom ) ) {
			$replacers				=	$this->params->get( 'replacers' );

			if ( ! $replacers ) {
				return;
			}

			if ( is_string( $replacers ) ) {
				// Legacy B/C fallback encase migration failed for some reason:
				$replacers			=	json_decode( $replacers, true );

				if ( ( ! $replacers ) || ( ! isset( $replacers['from'] ) ) ) {
					return;
				}

				foreach ( $replacers['from'] as $k => $from ) {
					if ( ! $from ) {
						continue;
					}

					$to				=	( $replacers['to'][$k] ?? '' );

					if ( ( $replacers['translate'][$k] ?? 0 ) ) {
						if ( $this->loadCB() ) {
							$from	=	CBTxt::T( $from );
							$to		=	CBTxt::T( $to );
						} else {
							$from	=	Text::_( $from );
							$to		=	Text::_( $to );
						}
					}

					if ( ( $replacers['substitutions'][$k] ?? 0 ) && $this->loadCB() ) {
						$to			=	CBuser::getMyInstance()->replaceUserVars( $to, false, false, null, false );
					}

					if ( ( $replacers['regexp'][$k] ?? 0 ) ) {
						$this->replacersFromRegexp[]	=	$from;
						$this->replacersToRegexp[]		=	$to;
					} elseif ( ( $replacers['casesensitive'][$k] ?? 0 ) ) {
						$this->replacersFromCase[]		=	$from;
						$this->replacersToCase[]		=	$to;
					} else {
						$this->replacersFrom[]			=	$from;
						$this->replacersTo[]			=	$to;
					}
				}
			} else {
				foreach ( $replacers as $replacer ) {
					$from			=	( $replacer->from ?? '' );

					if ( ! $from ) {
						continue;
					}

					$to				=	( $replacer->to ?? '' );

					if ( ( $replacer->translate ?? 0 ) ) {
						if ( $this->loadCB() ) {
							$from	=	CBTxt::T( $from );
							$to		=	CBTxt::T( $to );
						} else {
							$from	=	Text::_( $from );
							$to		=	Text::_( $to );
						}
					}

					if ( ( $replacer->substitutions ?? 0 ) && $this->loadCB() ) {
						$to			=	CBuser::getMyInstance()->replaceUserVars( $to, false, false, null, false );
					}

					if ( ( $replacer->regexp ?? 0 ) ) {
						$this->replacersFromRegexp[]	=	$from;
						$this->replacersToRegexp[]		=	$to;
					} elseif ( ( $replacer->casesensitive ?? 0 ) ) {
						$this->replacersFromCase[]		=	$from;
						$this->replacersToCase[]		=	$to;
					} else {
						$this->replacersFrom[]			=	$from;
						$this->replacersTo[]			=	$to;
					}
				}
			}
		}
	}

	/**
	 * @param string $context The context of the content being passed to the plugin.
	 * @param mixed  &$row    An object with a "text" property
	 * @param mixed  $params  Additional parameters. See {@see PlgContentContent()}.
	 * @param int    $page    Optional page number. Unused. Defaults to zero.
	 *
	 * @return void
	 */
	public function onContentPrepare( $context, &$row, &$params, $page = 0 ): void
	{
		if ( ( $context === 'com_finder.indexer' ) || ( ! isset( $row->text ) ) ) {
			return;
		}

		$this->getReplacers();

		if ( ( ! $this->replacersFromRegexp ) && ( ! $this->replacersFromCase ) && ( ! $this->replacersFrom ) ) {
			return;
		}

		if ( $this->replacersFromRegexp ) {
			$row->text	=	preg_replace( $this->replacersFromRegexp, $this->replacersToRegexp, $row->text );
		}

		if ( $this->replacersFrom ) {
			$row->text	=	str_ireplace( $this->replacersFrom, $this->replacersTo, $row->text );
		}

		if ( $this->replacersFromCase ) {
			$row->text	=	str_replace( $this->replacersFromCase, $this->replacersToCase, $row->text );
		}
	}
}