<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\TagTable;
use CB\Plugin\Activity\Tags;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var TagTable[]        $rows
 * @var UserTable         $viewer
 * @var Tags              $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var array             $integrations
 * @var array             $tags
 * @var int               $total
 */

global $_CB_framework;
?>
<span class="taggedStream streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $integrations ); ?>
	<?php
		if ( count( $tags ) > 2 ) {
			$tagOne		=	'<span class="taggedStreamTag">' . array_shift( $tags ) . '</span>';
			$tagTwo		=	'<span class="taggedStreamTag">' . array_shift( $tags ) . '</span>';

			$title		=	CBTxt::T( 'TAGGED_COUNT', '[tagged] Tag|[tagged] Tagged|%%COUNT%%', array( '%%COUNT%%' => $total, '[tagged]' => CBActivity::getFormattedTotal( $total ) ) );

			$more		=	'<a href="javascript: void(0);" class="cbTooltip streamModal taggedStreamMore" data-cbactivity-modal-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'tags', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ) . '" data-cbtooltip-title="' . htmlspecialchars( $title ) . '" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".taggedModalContainer" data-cbtooltip-width="800px" data-cbtooltip-height="600px" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad taggedModalContainer" data-cbtooltip-content-classes="p-0">'
						.		CBTxt::T( 'TAGGED_MORE', '[tagged] more', array( '%%COUNT%%' => ( $total - 2 ), '[tagged]' => CBActivity::getFormattedTotal( ( $total - 2 ) ) ) )
						.	'</a>';

			echo CBTxt::T( 'TAGS_MORE_THAN_TWO', '[tag_1], [tag_2], and [more]', array( '[tag_1]' => $tagOne, '[tag_2]' => $tagTwo, '[more]' => $more ) );
		} elseif ( count( $tags ) > 1 ) {
			echo CBTxt::T( 'TAGS_TWO', '[tag_1] and [tag_2]', array( '[tag_1]' => '<span class="taggedStreamTag">' . $tags[0] . '</span>', '[tag_2]' => '<span class="taggedStreamTag">' . $tags[1] . '</span>' ) );
		} else {
			echo '<span class="taggedStreamTag">' . $tags[0] . '</span>';
		}
	?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayStreamTagged', array( $rows, $viewer, $stream, $output ) ) ); ?>
</span>