<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Likes;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Likes             $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $layout
 * @var bool              $liked
 * @var bool              $canCreate
 */

global $_CB_framework;

$likeMenu				=	null;

if ( $canCreate && ( ! $liked ) && ( count( $stream->types() ) > 1 ) ) {
	$likeTypes			=	'<div class="d-flex likesStreamMenu streamItemActions" data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '">';

	foreach ( $stream->types() as $type ) {
		$likeTooltip	=	cbTooltip( null, CBTxt::T( $type->getString( 'value' ) ), null, 'auto', null, null, null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );

		$likeTypes		.=		'<div class="m-2 text-center likesStreamMenuItem"' . $likeTooltip . '>'
						.			'<a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'like', 'type' => $type->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="likeStreamButton likeStreamLike streamItemAction" data-cbactivity-container="stream">'
						.				'<div class="likesStreamMenuIcon">' . $type->icon() . '</div>'
						.				'<div class="d-block d-sm-none text-small likesStreamMenuTitle">' . CBTxt::T( $type->getString( 'value' ) ) . '</div>'
						.			'</a>'
						.		'</div>';
	}

	$likeTypes			.=	'</div>';

	$likeMenu			=	cbTooltip( null, $likeTypes, null, 'auto', null, null, null, 'data-hascbtooltip="true" data-cbtooltip-menu="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="likeStreamSelector" data-cbtooltip-adjust-y="0" data-cbtooltip-tip-hide="0" data-cbtooltip-content-classes="p-0"' );
}
?>
<?php if ( in_array( $layout, array( 'simple', 'extended' ), true ) ) { ?>
	<?php if ( $liked ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'unlike', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="likeStreamLink likeStreamUnlike streamItemAction" data-cbactivity-container="stream"><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Unlike' ); ?></a>
	<?php } elseif ( $likeMenu ) { ?>
	<a href="javascript: void(0);" class="likeStreamLink likeStreamLike"<?php echo $likeMenu; ?>><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Like' ); ?></a>
	<?php } else { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'like', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="likeStreamLink likeStreamLike streamItemAction" data-cbactivity-container="stream"><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Like' ); ?></a>
	<?php } ?>
<?php } else { ?>
<span class="likeStreamButtons">
	<?php if ( $liked ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'unlike', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="d-none btn btn-danger btn-sm likeStreamButton likeStreamUnlike streamItemAction" data-cbactivity-container="stream"><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Unlike' ); ?></a>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'unlike', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-info btn-sm likeStreamButton likeStreamLiked streamItemAction active" data-cbactivity-container="stream"><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Liked' ); ?></a>
	<?php } elseif ( $likeMenu ) { ?>
	<a href="javascript: void(0);" class="btn btn-info btn-sm likeStreamButton likeStreamLike"<?php echo $likeMenu; ?>><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Like' ); ?></a>
	<?php } else { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'likes', 'func' => 'like', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-info btn-sm likeStreamButton likeStreamLike streamItemAction" data-cbactivity-container="stream"><span class="fa fa-thumbs-o-up"></span> <?php echo CBTxt::T( 'Like' ); ?></a>
	<?php } ?>
</span>
<?php } ?>
