<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\FollowTable;
use CB\Plugin\Activity\Following;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var FollowTable[]     $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Following         $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var array             $integrations
 * @var int               $count
 */
?>
<div class="<?php echo ( $output === 'modal' ? 'p-2 ' : null ); ?>followingStream streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $output !== 'modal' ) { ?>
	<div class="row no-gutters mb-2 followingStreamToolbar streamToolbar">
		<?php if ( $stream->getBool( 'count', true ) ) { ?>
		<div class="col-6"><span class="badge badge-light border font-weight-normal followingStreamCount streamCount"><?php echo CBTxt::T( 'FOLLOWING_COUNT', '[followers] Follower|[followers] Followers|%%COUNT%%', array( '%%COUNT%%' => $pageNav->total, '[followers]' => CBActivity::getFormattedTotal( $pageNav->total ) ) ); ?></span></div>
		<?php } ?>
		<div class="col text-right"><?php echo $stream->following( 'button', 0, array( 'inline' => true, 'count' => false ) ); ?> </div>
	</div>
	<?php } ?>
	<div class="row no-gutters followingStreamItems streamItems">
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'following/rows', false ); ?>
	</div>
	<?php if ( $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block mt-2 followingButton followingButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayFollowingStream', array( $rows, $pageNav, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( $output === 'modal' ? CBActivity::reloadHeaders() : null ); ?>
</div>