<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\FollowTable;
use CB\Plugin\Activity\Following;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var FollowTable       $row
 * @var UserTable         $viewer
 * @var Following         $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 */

$cbUser	=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
?>
<div class="card no-overflow cbCanvasLayout cbCanvasLayoutSm streamItemInner">
	<div class="card-header p-0 position-relative cbCanvasLayoutTop follwerContainerCanvas">
		<div class="position-absolute cbCanvasLayoutBackground">
			<?php echo $cbUser->getField( 'canvas', null, 'html', 'none', 'profile', 0, true ); ?>
		</div>
	</div>
	<div class="position-relative cbCanvasLayoutBottom follwerContainerLogo">
		<div class="position-absolute cbCanvasLayoutPhoto">
			<?php echo $cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true ); ?>
		</div>
	</div>
	<div class="card-body p-2 position-relative cbCanvasLayoutBody follwerContainerContent">
		<div class="text-truncate cbCanvasLayoutContent follwerContainerContentInner">
			<?php echo $cbUser->getField( 'onlinestatus', null, 'html', 'none', 'profile', 0, true, array( 'params' => array( 'displayMode' => 1 ) ) ); ?>
			<?php echo $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true, array( 'params' => array( 'fieldHoverCanvas' => false ) ) ); ?>
		</div>
		<div class="text-small text-muted cbCanvasLayoutContent follwerContainerContentDate">
			<?php echo cbTooltip( null, cbFormatDate( $row->getString( 'date' ) ), null, 'auto', null, cbFormatDate( $row->getString( 'date' ), true, 'timeago' ), null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' ); ?>
		</div>
	</div>
</div>