<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Comments;
use CBLib\Input\Get;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend comment activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 *
 * @var string                          $pinnedTooltip
 * @var string                          $globalTooltip
 * @var string                          $reportedTooltip
 */

global $_CB_framework, $_PLUGINS;

$notification					=	( $stream instanceof NotificationsInterface );
$id								=	(int) $matches[2];
$type							=	( isset( $matches[3] ) ? $matches[3] : null );
$commentTitle					=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'show', 'id' => $id ) ) . '">#' . $id . '</a>';

switch ( $type ) {
	case 'reply':
		if ( $notification ) {
			$title				=	CBTxt::T( 'REPLIED_TO_COMMENT_TITLE', 'replied to comment [title]', array( '[title]' => $commentTitle ) );
		} else {
			$title				=	CBTxt::T( 'replied to this comment' );
		}
		break;
	case 'tag':
		if ( $notification ) {
			$title				=	CBTxt::T( 'TAGGED_IN_COMMENT_TITLE', 'tagged in comment [title]', array( '[title]' => $commentTitle ) );
		} else {
			$title				=	CBTxt::T( 'was tagged in this comment' );
		}
		break;
	case 'like':
		if ( $notification ) {
			$title				=	CBTxt::T( 'LIKED_COMMENT_TITLE', 'liked comment [title]', array( '[title]' => $commentTitle ) );
		} else {
			$title				=	CBTxt::T( 'liked this comment' );
		}
		break;
}

if ( $notification ) {
	$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'comments', 'func' => 'show', 'id' => $id ) ) );
}

/** @var CommentTable[] $cache */
static $cache					=	array();

if ( ! isset( $cache[$id] ) ) {
	$commentRow					=	new CommentTable();

	$commentRow->load( $id );

	if ( $stream->getBool( 'replies', false ) ) {
		CBActivity::prefetchAssets( 'comments', array( $commentRow ), $stream );
	}

	if ( $stream->getBool( 'tags', false ) ) {
		CBActivity::prefetchAssets( 'tags', array( $commentRow ), $stream );
	}

	if ( $stream->getBool( 'likes', false ) ) {
		CBActivity::prefetchAssets( 'likes', array( $commentRow ), $stream );
	}

	$cache[$id]					=	$commentRow;
}

$comment						=	$cache[$id];

if ( ! $comment->getInt( 'id', 0 ) ) {
	return;
}

$viewer							=	CBuser::getMyUserDataInstance();

if ( $notification ) {
	$commentTitle				=	$stream->parser( $comment->getString( 'message' ), $comment )->parse( array( 'linebreaks' ), false );
	$commentInsert				=	null;
	$commentDate				=	null;
	$commentFooter				=	null;
	$commentMenu				=	array();

	if ( $commentTitle ) {
		if ( cbutf8_strlen( $commentTitle ) > 50 ) {
			$commentTitle	=	trim( cbutf8_substr( $commentTitle, 0, 50 ) ) . '...';
		}

		$commentTitle			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'show', 'id' => $id ) ) . '">' . $commentTitle . '</a>';
	}

	$orgCommentTitle			=	$commentTitle;

	$comment->set( '_notification', $row );
	$comment->set( '_notification_id', $id );
	$comment->set( '_notification_type', $type );

	$_PLUGINS->trigger( 'activity_onDisplayStreamComment', array( &$comment, &$commentTitle, &$commentInsert, &$commentDate, &$commentFooter, &$commentMenu, $stream, $output ) );

	if ( ! $orgCommentTitle ) {
		// There is no original title, but we need to be able to link to the comment entry so lets override the integration title and just force it to link:
		$commentTitle			=	htmlspecialchars( Get::clean( $commentTitle, GetterInterface::STRING ) );

		if ( cbutf8_strlen( $commentTitle ) > 100 ) {
			$commentTitle		=	trim( cbutf8_substr( $commentTitle, 0, 100 ) ) . '...';
		}

		$commentTitle			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'show', 'id' => $id ) ) . '">' . $commentTitle . '</a>';
	}

	if ( $commentTitle ) {
		switch ( $type ) {
			case 'reply':
				if ( $viewer->getInt( 'id', 0 ) === $comment->getInt( 'user_id', 0 ) ) {
					$title		=	CBTxt::T( 'REPLIED_TO_YOUR_COMMENT_TITLE', 'replied to your comment [title]', array( '[title]' => $commentTitle ) );
				} else {
					$title		=	CBTxt::T( 'REPLIED_TO_COMMENT_TITLE', 'replied to comment [title]', array( '[title]' => $commentTitle ) );
				}
				break;
			case 'tag':
				if ( $viewer->getInt( 'id', 0 ) !== $comment->getInt( 'user_id', 0 ) ) {
					$title		=	CBTxt::T( 'TAGGED_YOU_IN_COMMENT_TITLE', 'tagged you in comment [title]', array( '[title]' => $commentTitle ) );
				} else {
					$title		=	CBTxt::T( 'TAGGED_IN_COMMENT_TITLE', 'tagged in comment [title]', array( '[title]' => $commentTitle ) );
				}
				break;
			case 'like':
				if ( $viewer->getInt( 'id', 0 ) === $comment->getInt( 'user_id', 0 ) ) {
					$title		=	CBTxt::T( 'LIKED_YOUR_COMMENT_TITLE', 'liked your comment [title]', array( '[title]' => $commentTitle ) );
				} else {
					$title		=	CBTxt::T( 'LIKED_COMMENT_TITLE', 'liked comment [title]', array( '[title]' => $commentTitle ) );
				}
				break;
			default:
				if ( ! $title ) {
					$title		=	CBTxt::T( 'COMMENTED_TITLE', 'commented [title]', array( '[title]' => $commentTitle ) );
				} else {
					if ( $viewer->getInt( 'id', 0 ) === $comment->getInt( 'user_id', 0 ) ) {
						$title	=	CBTxt::T( 'TITLE_ON_YOUR_COMMENT', '[title] on your comment [comment]', array( '[title]' => $title, '[comment]' => $commentTitle ) );
					} else {
						$title	=	CBTxt::T( 'TITLE_ON_COMMENT', '[title] on comment [comment]', array( '[title]' => $title, '[comment]' => $commentTitle ) );
					}
				}
				break;
		}

		// If this comment notification is about a comment on an activity entry lets append that as well:
		if ( preg_match( '/^(?:(.+)\.)?activity\.(\d+)(?:\.(comment|tag|like)(?:\.(\d+))?)?/', $comment->getString( 'asset' ), $matches ) ) {
			$activityMessage	=	null;
			$activityInsert		=	null;
			$activityDate		=	null;
			$activityFooter		=	null;
			$activityMenu		=	array();

			// We want the current scoped variables be left alone so lets call activity display using an anonymous function:
			$display			=	function ( &$date, &$message, &$insert, &$footer, &$menu ) use ( &$row, &$title, $stream, $matches, $output, $pinnedTooltip, $globalTooltip, $reportedTooltip ) {
										require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display/activity', false );
									};

			$display( $activityMessage, $activityDate, $activityInsert, $activityFooter, $activityMenu );
		}
	}
} else {
	$comment->params()->set( 'overrides.menu', false );

	$comments					=	$row->comments( $stream );

	$inlineCache				=	$comments->getBool( 'inline', false );
	$repliesCache				=	$comments->getBool( 'replies', false );

	$comments->set( 'inline', false );
	$comments->set( 'replies', false );

	// We want the current scoped variables be left alone so lets call comment display using an anonymous function:
	$display					=	function ( &$row, $stream ) use ( $viewer, $output, $pinnedTooltip, $reportedTooltip ) {
										/**
										 * @var CommentTable $row
										 * @var Comments     $stream
										 */
										ob_start();
										require CBActivity::getTemplate( $stream->getString( 'template' ), 'comments/container', false );
										$html	=	ob_get_contents();
										ob_end_clean();

										return $html;
									};

	$insert						=	'<div class="border-top mt-2 mb-2 streamItemDivider"></div>'
								.	$display( $comment, $comments );

	$comments->set( 'inline', $inlineCache );
	$comments->set( 'replies', $repliesCache );

	$comment->params()->set( 'overrides.menu', true );

	$row->params()->set( 'overrides.compact', true );
	$row->params()->set( 'overrides.edit', false );
	$row->params()->set( 'overrides.likes', false );
}