<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\Activity\CBActivity;
use CBLib\Input\Get;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend activity activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 *
 * @var string                          $pinnedTooltip
 * @var string                          $globalTooltip
 * @var string                          $reportedTooltip
 */

global $_CB_framework, $_PLUGINS;

$notification						=	( $stream instanceof NotificationsInterface );
$id									=	(int) $matches[2];
$type								=	( isset( $matches[3] ) ? $matches[3] : null );
$activityTitle						=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'show', 'id' => $id ) ) . '">#' . $id . '</a>';

switch ( $type ) {
	case 'comment':
		if ( $notification ) {
			$title					=	CBTxt::T( 'COMMENTED_ON_POST_TITLE', 'commented on post [title]', array( '[title]' => $activityTitle ) );
		} else {
			$title					=	CBTxt::T( 'commented on this' );
		}
		break;
	case 'tag':
		if ( $notification ) {
			$title					=	CBTxt::T( 'TAGGED_IN_POST_TITLE', 'tagged in post [title]', array( '[title]' => $activityTitle ) );
		} else {
			$title					=	CBTxt::T( 'was tagged in this' );
		}
		break;
	case 'like':
		if ( $notification ) {
			$title					=	CBTxt::T( 'LIKED_POST_TITLE', 'liked post [title]', array( '[title]' => $activityTitle ) );
		} else {
			$title					=	CBTxt::T( 'liked this' );
		}
		break;
}

if ( $notification ) {
	$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbactivity', false, array( 'action' => 'activity', 'func' => 'show', 'id' => $id ) ) );
}

/** @var ActivityTable[] $cache */
static $cache						=	array();

$activity							=	$stream->row( $id );

if ( ! $activity->getInt( 'id', 0 ) ) {
	if ( ! isset( $cache[$id] ) ) {
		$activityRow				=	new ActivityTable();

		$activityRow->load( $id );

		if ( $stream->getBool( 'comments', true ) ) {
			CBActivity::prefetchAssets( 'comments', array( $activityRow ), $stream );
		}

		if ( $stream->getBool( 'tags', true ) ) {
			CBActivity::prefetchAssets( 'tags', array( $activityRow ), $stream );
		}

		if ( $stream->getBool( 'likes', true ) ) {
			CBActivity::prefetchAssets( 'likes', array( $activityRow ), $stream );
		}

		$cache[$id]					=	$activityRow;
	}

	$activity						=	$cache[$id];
}

if ( ! $activity->getInt( 'id', 0 ) ) {
	return;
}

$viewer								=	CBuser::getMyUserDataInstance();

if ( $notification ) {
	$activityTitle					=	$stream->parser( $activity->getString( 'title' ), $activity )->parse( array( 'linebreaks' ), false );

	if ( ! $activityTitle ) {
		$activityTitle				=	$stream->parser( $activity->getString( 'message' ), $activity )->parse( array( 'linebreaks' ), false );
	}

	$activityDate					=	null;
	$activityMessage				=	null;
	$activityInsert					=	null;
	$activityFooter					=	null;
	$activityMenu					=	array();

	if ( $activityTitle ) {
		if ( cbutf8_strlen( $activityTitle ) > 50 ) {
			$activityTitle			=	trim( cbutf8_substr( $activityTitle, 0, 50 ) ) . '...';
		}

		$activityTitle				=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'show', 'id' => $id ) ) . '">' . $activityTitle . '</a>';
	}

	$orgActivityTitle				=	$activityTitle;

	// We want the current scoped variables be left alone so lets cache the current values so we can restore them:
	$display						=	function ( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu ) use ( $stream, $output, $pinnedTooltip, $globalTooltip, $reportedTooltip ) {
											require CBActivity::getTemplate( $stream->getString( 'template' ), 'core/display', false );
										};

	$activity->set( '_notification', $row );
	$activity->set( '_notification_id', $id );
	$activity->set( '_notification_type', $type );

	$display( $activity, $activityTitle, $activityDate, $activityMessage, $activityInsert, $activityFooter, $activityMenu );

	$_PLUGINS->trigger( 'activity_onDisplayStreamActivity', array( &$activity, &$activityTitle, &$activityDate, &$activityMessage, &$activityInsert, &$activityFooter, &$activityMenu, $stream, $output ) );

	if ( ! $orgActivityTitle ) {
		// There is no original title, but we need to be able to link to the activity entry so lets override the integration title and just force it to link:
		$activityTitle				=	htmlspecialchars( Get::clean( $activityTitle, GetterInterface::STRING ) );

		if ( cbutf8_strlen( $activityTitle ) > 100 ) {
			$activityTitle			=	trim( cbutf8_substr( $activityTitle, 0, 100 ) ) . '...';
		}

		$activityTitle				=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'show', 'id' => $id ) ) . '">' . $activityTitle . '</a>';
	}

	if ( $activityTitle ) {
		switch ( $type ) {
			case 'comment':
				if ( $viewer->getInt( 'id', 0 ) === $activity->getInt( 'user_id', 0 ) ) {
					$title			=	CBTxt::T( 'COMMENTED_ON_YOUR_POST_TITLE', 'commented on your post [title]', array( '[title]' => $activityTitle ) );
				} else {
					$title			=	CBTxt::T( 'COMMENTED_ON_POST_TITLE', 'commented on post [title]', array( '[title]' => $activityTitle ) );
				}
				break;
			case 'tag':
				if ( $viewer->getInt( 'id', 0 ) !== $activity->getInt( 'user_id', 0 ) ) {
					$title			=	CBTxt::T( 'TAGGED_YOU_IN_POST_TITLE', 'tagged you in post [title]', array( '[title]' => $activityTitle ) );
				} else {
					$title			=	CBTxt::T( 'TAGGED_IN_POST_TITLE', 'tagged in post [title]', array( '[title]' => $activityTitle ) );
				}
				break;
			case 'like':
				if ( $viewer->getInt( 'id', 0 ) === $activity->getInt( 'user_id', 0 ) ) {
					$title			=	CBTxt::T( 'LIKED_YOUR_POST_TITLE', 'liked your post [title]', array( '[title]' => $activityTitle ) );
				} else {
					$title			=	CBTxt::T( 'LIKED_POST_TITLE', 'liked post [title]', array( '[title]' => $activityTitle ) );
				}
				break;
			default:
				if ( ! $title ) {
					if ( preg_match( '/^profile\.(\d+)/', $activity->getString( 'asset' ), $matches ) ) {
						$profileId	=	( isset( $matches[1] ) ? (int) $matches[1] : 0 );

						if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
							$title	=	CBTxt::T( 'POSTED_ON_YOUR_PROFILE_TITLE', 'posted on your profile [title]', array( '[title]' => $activityTitle ) );
						} else {
							$title	=	CBTxt::T( 'POSTED_TITLE', 'posted [title]', array( '[title]' => $activityTitle ) );
						}
					} else {
						$title		=	CBTxt::T( 'POSTED_TITLE', 'posted [title]', array( '[title]' => $activityTitle ) );
					}
				} else {
					if ( preg_match( '/^profile\.(\d+)/', $activity->getString( 'asset' ), $matches ) ) {
						$profileId	=	( isset( $matches[1] ) ? (int) $matches[1] : 0 );

						if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
							$title	=	CBTxt::T( 'TITLE_ON_YOUR_PROFILE_POST', '[title] on your profile post [post]', array( '[title]' => $title, '[post]' => $activityTitle ) );
						} else {
							$title	=	CBTxt::T( 'TITLE_ON_POST', '[title] on post [post]', array( '[title]' => $title, '[post]' => $activityTitle ) );
						}
					} else {
						$title		=	CBTxt::T( 'TITLE_ON_POST', '[title] on post [post]', array( '[title]' => $title, '[post]' => $activityTitle ) );
					}
				}
				break;
		}
	}
} else {
	$message						=	null;

	$activity->params()->set( 'overrides.inline', true );

	// We want the current scoped variables be left alone so lets call activity display using an anonymous function:
	$display					=	function ( &$row ) use ( $stream, $viewer, $output, $pinnedTooltip, $globalTooltip, $reportedTooltip ) {
										/**
										 * @var ActivityTable $row
										 * @var Activity      $stream
										 */
										ob_start();
										require CBActivity::getTemplate( $stream->getString( 'template' ), 'activity/container', false );
										$html	=	ob_get_contents();
										ob_end_clean();

										return $html;
									};

	$insert							=	'<div class="border-top mt-2 mb-2 streamItemDivider"></div>'
									.	$display( $activity );

	$activity->params()->set( 'overrides.inline', false );

	$row->params()->set( 'overrides.compact', true );
	$row->params()->set( 'overrides.edit', false );
	$row->params()->set( 'overrides.likes', false );
	$row->params()->set( 'overrides.comments', false );
}