<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\Activity\CBActivity;
use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CBLib\Registry\ParamsInterface;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable|CommentTable|NotificationTable $row
 * @var UserTable                                    $viewer
 * @var Activity|Comments|Notifications              $stream
 * @var CBplug_cbactivity                            $this
 * @var string                                       $output
 *
 * @var ParamsInterface                              $link
 * @var ParamsInterface                              $media
 */

$mediaFilename		=	$media->getString( 'filename' );

if ( ! $mediaFilename ) {
	$mediaFilename	=	$link->getString( 'url' );
}
?>
<div class="table-responsive streamItemFile">
	<table class="table table-sm table-bordered w-100 m-0 streamItemFileTable">
		<tbody>
			<tr>
				<th style="width: 150px;" class="d-block d-md-table-cell w-md-100"><?php echo CBTxt::T( 'File' ); ?></th>
				<td class="d-block d-md-table-cell w-md-100 text-wrap"><a href="<?php echo htmlspecialchars( $link->getString( 'url' ) ); ?>" target="_blank" rel="nofollow noopener"><?php echo htmlspecialchars( $mediaFilename ); ?></a></td>
			</tr>
			<tr>
				<th style="width: 150px;" class="d-block d-md-table-cell w-md-100"><?php echo CBTxt::T( 'Extension' ); ?></th>
				<td class="d-block d-md-table-cell w-md-100 text-wrap"><?php echo htmlspecialchars( strtolower( preg_replace( '/[^-a-zA-Z0-9_]/', '', $media->getString( 'extension' ) ) ) ); ?></td>
			</tr>
			<tr>
				<th style="width: 150px;" class="d-block d-md-table-cell w-md-100"><?php echo CBTxt::T( 'Size' ); ?></th>
				<td class="d-block d-md-table-cell w-md-100 text-wrap"><?php echo CBActivity::getFormattedFileSize( $media->getInt( 'filesize', 0 ) ); ?></td>
			</tr>
			<tr>
				<th style="width: 150px;" class="d-block d-md-table-cell w-md-100"><?php echo CBTxt::T( 'Modified' ); ?></th>
				<td class="d-block d-md-table-cell w-md-100 text-wrap"><?php echo ( $link->getString( 'date' ) ? cbFormatDate( $link->getString( 'date' ) ) : '-' ); ?></td>
			</tr>
		</tbody>
	</table>
</div>