<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CBLib\Registry\ParamsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable|CommentTable|NotificationTable $row
 * @var UserTable                                    $viewer
 * @var Activity|Comments|Notifications              $stream
 * @var CBplug_cbactivity                            $this
 * @var string                                       $output
 */

global $_PLUGINS;

$links		=	$row->attachments();

$_PLUGINS->trigger( 'activity_onEditStreamAttachments', array( &$row, &$links, $viewer, $stream, $output ) );

$count		=	$links->count();

if ( ! $count ) {
	return;
}

$cbUser		=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
?>
<?php if ( $count > 1 ) { ?>
<div class="row no-gutters streamItemScroll">
	<div class="d-flex flex-column justify-content-center pr-2 streamItemScrollLeft">
		<span class="fa fa-chevron-left streamItemScrollLeftIcon"></span>
	</div>
<?php } ?>
	<?php
	foreach ( $links as $i => $link ) {
		/** @var ParamsInterface $link */
		$type		=	$link->getString( 'type', 'url' );
		$external	=	( ( ! $link->getBool( 'internal', false ) ) || ( $type === 'image' ) ? ' target="_blank" rel="nofollow noopener"' : null );
	?>
	<div class="<?php echo ( $type === 'url' ? 'bg-light border p-2 ' : null ) . ( $count > 1 ? 'col streamItemScrollContent ' : null ); ?>streamItemAttachment<?php echo ( $i !== 0 ? ' hidden' : null ); ?>">
		<div class="<?php echo ( $type === 'url' ? 'd-block d-sm-flex media streamMedia ' : 'card rounded-0 streamPanel ' ); ?>streamItemAttachmentInner">
			<?php
			if ( $link->getRaw( 'media' ) !== false ) {
				/** @var ParamsInterface $media */
				$media	=	$link->subTree( 'media' );
			?>
			<div class="<?php echo ( $type === 'url' ? 'mb-2 mb-sm-0 pr-sm-2 media-left w-sm-100 mw-50 mw-sm-100 streamMediaLeft ' : ( $type === 'video' ? 'p-0 ' : 'p-2 ' ) . 'card-body streamPanelBody ' ); ?>streamItemAttachmentMedia">
			<?php
			switch ( $type ) {
				case 'custom':
					echo $cbUser->replaceUserVars( $media->getRaw( 'custom' ), false, false, null, false );
					break;
				case 'video':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/video', false );
					break;
				case 'audio':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/audio', false );
					break;
				case 'image':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/image', false );
					break;
				case 'file':
					require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/file', false );
					break;
				case 'url':
				default:
					if ( $link->getRaw( 'thumbnails' ) !== false ) {
						/** @var ParamsInterface $thumbnails */
						$thumbnails		=	$link->subTree( 'thumbnails' );

						if ( $thumbnails->count() > 1 ) {
							$selected	=	$link->getInt( 'selected', 0 );
							?>
							<div class="streamItemScroll">
								<?php foreach ( $thumbnails as $t => $thumbnail ) { ?>
								<div class="streamItemScrollContent<?php echo ( $t !== $selected ? ' hidden' : null ); ?>">
									<a href="<?php echo htmlspecialchars( $link->getString( 'url' ) ); ?>"<?php echo $external; ?>>
										<img src="<?php echo htmlspecialchars( $thumbnail->getString( 'url' ) ); ?>" loading="lazy" class="img-fluid w-auto mw-100 streamItemImage" />
									</a>
									<input type="hidden" name="links[<?php echo $i; ?>][selected]" value="<?php echo $t; ?>" class="streamItemScrollDisable"<?php echo ( $t !== $selected ? ' disabled="disabled"' : null ); ?> />
								</div>
								<?php } ?>
								<div class="text-center mt-1 streamItemScroller">
									<span class="streamItemScrollLeft"><span class="streamItemScrollLeftIcon fa fa-chevron-left"></span></span>
									<span class="streamItemScrollRight"><span class="streamItemScrollRightIcon fa fa-chevron-right"></span></span>
								</div>
							</div>
							<?php
						} else {
							require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/url', false );
						}
					} else {
						require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/url', false );
					}
					break;
			}
			?>
			</div>
			<?php } ?>
			<?php if ( $type !== 'custom' ) { ?>
			<div class="<?php echo ( $type === 'url' ? 'media-body streamMediaBody' : 'card-footer p-2 streamPanelFooter' ); ?> streamItemAttachmentInfo">
				<input type="text" name="links[<?php echo $i; ?>][title]" value="<?php echo htmlspecialchars( $link->getString( 'title' ) ); ?>" class="form-control w-100 streamInput streamInputLinkTitle" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Title' ) ); ?>" />
				<textarea name="links[<?php echo $i; ?>][description]" rows="1" class="form-control w-100 mt-1 streamInput streamInputAutosize streamInputLinkDescription" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Description' ) ); ?>"><?php echo htmlspecialchars( $link->getString( 'description' ) ); ?></textarea>
				<?php if ( $type === 'url' ) { ?>
				<div class="mt-1 form-check streamInput">
					<input type="checkbox" id="links__<?php echo $i; ?>__thumbnail" name="links[<?php echo $i; ?>][thumbnail]" value="0"<?php echo ( ! $link->getBool( 'thumbnail', true ) ? ' checked="checked"' : null ); ?> class="form-check-input" />
					<label class="form-check-label" for="links__<?php echo $i; ?>__thumbnail">
						<?php echo CBTxt::T( 'Do not display thumbnail' ); ?>
					</label>
				</div>
				<?php } ?>
				<?php if ( $link->getBool( 'embedded', false )  ) { ?>
				<input type="hidden" name="links[<?php echo $i; ?>][embedded]" value="1" />
				<?php } ?>
				<input type="hidden" name="links[<?php echo $i; ?>][parsed]" value="1" />
			</div>
			<?php } elseif ( $count > 1 ) { ?>
			<div class="<?php echo ( $type === 'url' ? 'media-body streamMediaBody ' : null ); ?>streamItemAttachmentInfo">
				<div class="text-small streamItemAttachmentUrl">
					<div class="text-muted text-right streamItemAttachmentCount"><?php echo ( $i + 1 ); ?> - <?php echo $count; ?></div>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
	<?php } ?>
<?php if ( $count > 1 ) { ?>
	<div class="d-flex flex-column justify-content-center pl-2 streamItemScrollRight">
		<span class="fa fa-chevron-right streamItemScrollRightIcon"></span>
	</div>
</div>
<?php } ?>
