<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Trigger;

use CB\Plugin\Activity\Table\FollowTable;
use CB\Plugin\Activity\Table\LikeTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\ReadTable;
use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Table\TagTable;
use CB\Plugin\Activity\Table\HiddenTable;
use CB\Plugin\Activity\CBActivity;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * Deletes items when the user is deleted
	 *
	 * @param  UserTable $user
	 * @param  int       $status
	 */
	public function deleteActivity( $user, $status )
	{
		global $_CB_database;

		if ( ! CBActivity::getGlobalParams()->getBool( 'general_delete', true ) ) {
			return;
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_hidden' )
						.	"\n WHERE ( " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
						.	" OR ( " . $_CB_database->NameQuote( 'type' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'activity.user', 'comment.user', 'notification.user' ) )
						.	" AND " . $_CB_database->NameQuote( 'object' ) . " = " . $user->getInt( 'id', 0 ) . " ) )";
		$_CB_database->setQuery( $query );
		$hidden			=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\HiddenTable', array( $_CB_database ) );

		/** @var HiddenTable[] $hidden */
		foreach ( $hidden as $hide ) {
			$hide->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_read' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$reads			=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\ReadTable', array( $_CB_database ) );

		/** @var ReadTable[] $reads */
		foreach ( $reads as $read ) {
			$read->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_notifications' )
						.	"\n WHERE ( " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
						.	" OR " . $_CB_database->NameQuote( 'user' ) . " = " . $user->getInt( 'id', 0 ) . " )";
		$_CB_database->setQuery( $query );
		$notifications	=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\NotificationTable', array( $_CB_database ) );

		/** @var NotificationTable[] $notifications */
		foreach ( $notifications as $notification ) {
			$notification->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$activities		=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\ActivityTable', array( $_CB_database ) );

		/** @var ActivityTable[] $activities */
		foreach ( $activities as $activity ) {
			$activity->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_comments' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$comments		=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\CommentTable', array( $_CB_database ) );

		/** @var CommentTable[] $comments */
		foreach ( $comments as $comment ) {
			$comment->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_tags' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$tags			=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\TagTable', array( $_CB_database ) );

		/** @var TagTable[] $tags */
		foreach ( $tags as $tag ) {
			$tag->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_following' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$following		=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\FollowTable', array( $_CB_database ) );

		/** @var FollowTable[] $following */
		foreach ( $following as $follow ) {
			$follow->delete();
		}

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_activity_likes' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		$_CB_database->setQuery( $query );
		$likes			=	$_CB_database->loadObjectList( null, '\CB\Plugin\Activity\Table\LikeTable', array( $_CB_database ) );

		/** @var LikeTable[] $likes */
		foreach ( $likes as $like ) {
			$like->delete();
		}
	}
}