<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveUsers
{

	/**
	 * render frontend group users
	 *
	 * @param CB\Plugin\GroupJive\Table\UserTable[] $rows
	 * @param cbPageNav                             $pageNav
	 * @param bool                                  $searching
	 * @param array                                 $input
	 * @param GroupTable                            $group
	 * @param UserTable                             $user
	 * @param CBplug_cbgroupjive                    $plugin
	 * @return string
	 */
	public static function showUsers( $rows, $pageNav, $searching, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner						=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus						=	CBGroupJive::getGroupStatus( $user, $group );
		$canSearch						=	( $plugin->params->getInt( 'groups_users_search', 0 ) && ( $searching || $pageNav->total ) );
		$return							=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayUsers', array( &$return, &$rows, $group, $user ) );

		$return							.=	'<div class="gjGroupUsers">';

		if ( $canSearch ) {
			$return						.=		'<div class="row no-gutters mb-3 gjHeader gjGroupUsersHeader">'
										.			'<div class="col-12 offset-sm-6 col-sm-6 text-right">'
										.				'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupUsersSearchForm" class="m-0 gjGroupUsersSearchForm">'
										.					'<div class="input-group">'
										.						$input['search']
										.						'<div class="input-group-append">'
										.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
										.						'</div>'
										.					'</div>'
										.				'</form>'
										.			'</div>'
										.		'</div>';
		}

		if ( $rows ) {
			$return						.=		'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjGroupUsersRows">';

			foreach ( $rows as $row ) {
				$canModerate			=	( ( $userStatus >= 2 ) && ( $userStatus > $row->getInt( 'status', 0 ) ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) );

				$counters				=	array();
				$content				=	null;
				$menu					=	array();

				$_PLUGINS->trigger( 'gj_onDisplayUser', array( &$row, &$counters, &$content, &$menu, $group, $user ) );

				$cbUser					=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );

				switch ( $row->getInt( 'status', 0 ) ) {
					case -1:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-ban text-danger"></span> ';
						$cssClass		=	'gjGroupUsersUserBanned';
						break;
					case 0:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-warning text-warning"></span> ';
						$cssClass		=	'gjGroupUsersUserPending';
						break;
					case 1:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-user"></span> ';
						$cssClass		=	'gjGroupUsersUserActive';
						break;
					case 2:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-gavel text-success"></span> ';
						$cssClass		=	'gjGroupUsersUserModerator';
						break;
					case 3:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-gavel text-success"></span> ';
						$cssClass		=	'gjGroupUsersUserAdmin';
						break;
					case 4:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-star text-primary"></span> ';
						$cssClass		=	'gjGroupUsersUserOwner';
						break;
					default:
						$icon			=	'<span class="gjGroupUserIconStatus fa fa-question text-warning"></span> ';
						$cssClass		=	'gjGroupUsersUserUnknown';
						break;
				}

				$buttons				=	array();

				if ( ( $isModerator || $isOwner || $canModerate ) && ( $row->getInt( 'status', 0 ) === 0 ) && ( $group->getInt( 'type', 0 ) === 2 ) ) {
					$buttons[]			=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'active', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="btn btn-block btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Join Request' ) . '</a>';
				}

				$menuButton				=	null;

				if ( ( $isModerator || $isOwner || $canModerate || $menu ) && ( $row->getInt( 'status', 0 ) !== 4 ) ) {
					$menuItems			=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjGroupUsersUserMenuItems">';

					if ( $isModerator || $isOwner ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to promote this user to Owner?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'owner', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-thumbs-o-up"></span> ' . CBTxt::T( 'Promote to Owner' ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner ) && ( $row->getInt( 'status', 0 ) <= 2 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to promote this user to Admin?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'admin', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-thumbs-o-up"></span> ' . CBTxt::T( 'Promote to Admin' ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner || ( $canModerate && ( $userStatus >= 3 ) ) ) && ( $row->getInt( 'status', 0 ) <= 1 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to promote this user to Moderator?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'moderator', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-thumbs-o-up"></span> ' . CBTxt::T( 'Promote to Moderator' ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner || ( $canModerate && ( $userStatus >= 2 ) ) ) && ( $row->getInt( 'status', 0 ) <= 0 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'active', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-thumbs-o-up"></span> ' . ( ( $row->getInt( 'status', 0 ) === 0 ) && ( $group->getInt( 'type', 0 ) === 2 ) ? CBTxt::T( 'Approve' ) : CBTxt::T( 'Promote to Member' ) ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner ) && ( $row->getInt( 'status', 0 ) >= 3 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to demote this user to Moderator?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'moderator', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-thumbs-o-down"></span> ' . CBTxt::T( 'Demote to Moderator' ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner || ( $canModerate && ( $userStatus >= 3 ) ) ) && ( $row->getInt( 'status', 0 ) >= 2 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to demote this user to Member?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'active', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-thumbs-o-down"></span> ' . CBTxt::T( 'Demote to Member' ) . '</a></li>';
					}

					if ( ( $isModerator || $isOwner || ( $canModerate && ( $userStatus >= 2 ) ) ) && ( $row->getInt( 'status', 0 ) >= 0 ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to ban this User?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'ban', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-ban"></span> ' . CBTxt::T( 'Ban' ) . '</a></li>';
					}

					if ( $menu ) {
						$menuItems		.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjGroupMenuItem">', $menu ) . '</li>';
					}

					if ( $isModerator || $isOwner || ( $canModerate && ( $userStatus >= 3 ) ) ) {
						$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this User?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'users', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . ( ( $row->getInt( 'status', 0 ) === 0 ) && ( $group->getInt( 'type', 0 ) === 2 ) ? CBTxt::T( 'Reject' ) : CBTxt::T( 'Delete' ) ) . '</a></li>';
					}

					$menuItems			.=	'</ul>';

					$menuAttr			=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu gjGroupUsersUserMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					$menuButton			=	'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
				}

				$return					.=			'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjGroupUsersUser ' . htmlspecialchars( $cssClass ) . '">'
										.				'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutSm">'
										.					'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
										.						'<div class="position-absolute cbCanvasLayoutBackground">'
										.							$cbUser->getField( 'canvas', null, 'html', 'none', 'profile', 0, true )
										.						'</div>';

				if ( $menuButton ) {
					$return				.=						'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
										.							$menuButton
										.						'</div>';
				}

				$return					.=					'</div>'
										.					'<div class="position-relative cbCanvasLayoutBottom">'
										.						'<div class="position-absolute cbCanvasLayoutPhoto">'
										.							$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
										.						'</div>'
										.					'</div>'
										.					'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
										.						'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">'
										.							$cbUser->getField( 'onlinestatus', null, 'html', 'none', 'profile', 0, true, array( 'params' => array( 'displayMode' => 1 ) ) )
										.							' <span class="text-large">' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true, array( 'params' => array( 'fieldHoverCanvas' => false ) ) ) . '</span>'
										.						'</div>'
										.						'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
										.							'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjGroupUsersUserIconStatus">' . $icon . $row->status() . '</div>'
										.							( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
										.						'</div>'
										.						( $content ? '<div class="m-2 cbCanvasLayoutContent gjGroupUsersUserIntegrations">' . $content . '</div>' : null );

				if ( $buttons ) {
					$return				.=						'<div class="pl-2 pr-2 mb-2 cbCanvasLayoutButtons">'
										.							implode( ' ', $buttons )
										.						'</div>';
				}

				$return					.=					'</div>'
										.				'</div>'
										.			'</div>';
			}

			$return						.=		'</div>';

			if ( $plugin->params->getInt( 'groups_users_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return					.=		'<div class="mt-3 gjGroupUsersPaging">'
										.				$pageNav->getListLinks()
										.		'</div>';
			}
		} else {
			$return						.=		'<div class="gjGroupUsersEmpty">';

			if ( $searching ) {
				$return					.=			CBTxt::T( 'No group user search results found.' );
			} else {
				$return					.=			CBTxt::T( 'This group currently has no users.' );
			}

			$return						.=		'</div>';
		}

		$return							.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayUsers', array( &$return, &$rows, $group, $user ) );

		return $return;
	}
}