<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Registry\Registry;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveTab
{

	/**
	 * render frontend tab
	 *
	 * @param GroupTable[] $rows
	 * @param cbPageNav    $pageNav
	 * @param bool         $searching
	 * @param array        $input
	 * @param UserTable    $viewer
	 * @param UserTable    $user
	 * @param TabTable     $tab
	 * @param cbgjTab      $plugin
	 * @return string
	 */
	public static function showTab( $rows, $pageNav, $searching, $input, $viewer, $user, $tab, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		/** @var Registry $params */
		$params								=	$tab->params;

		$isModerator						=	CBGroupJive::isModerator( $viewer->getInt( 'id', 0 ) );
		$canCreateGroup						=	( $isModerator || ( $viewer->getInt( 'id', 0 ) === $user->getInt( 'id', 0 ) ) ? CBGroupJive::canCreateGroup( $viewer ) : false );
		$canSearch							=	( $params->getInt( 'tab_search', 1 ) && ( $searching || $pageNav->total ) );
		$returnUrl							=	base64_encode( $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), false, $tab->getInt( 'tabid', 0 ) ) );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayTab', array( &$return, &$rows, $viewer, $user, $tab ) );

		$return								.=	'<div class="gjTab">';

		if ( $canCreateGroup || $canSearch ) {
			$return							.=		'<div class="row no-gutters mb-3 gjHeader gjTabHeader">';

			if ( $canCreateGroup ) {
				$return						.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'new', 'user' => $user->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewGroup"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Group' ) . '</a>'
											.			'</div>';
			}

			if ( $canSearch ) {
				$return						.=			'<div class="col-12 ' . ( ! $canCreateGroup ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.				'<form action="' . $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), true, $tab->getInt( 'tabid', 0 ) ) . '" method="post" name="gjTabSearchForm" class="m-0 gjTabSearchForm">'
											.					'<div class="input-group">'
											.						$input['search']
											.						'<div class="input-group-append">'
											.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.						'</div>'
											.					'</div>'
											.				'</form>'
											.			'</div>';
			}

			$return							.=		'</div>';
		}

		if ( $rows ) {
			$return							.=		'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjTabRows">';

			foreach ( $rows as $row ) {
				$rowOwner					=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$userStatus					=	CBGroupJive::getGroupStatus( $viewer, $row );
				$cssClass					=	$row->getString( 'css' );

				$counters					=	array();
				$content					=	null;
				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayGroup', array( &$row, &$counters, &$content, &$menu, 'profile', $user ) );

				$buttons					=	array();

				if ( $isModerator && ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
					$buttons[]				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-block btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Group' ) . '</a>';
				} elseif ( ( ! $rowOwner ) && ( $row->getInt( 'type', 0 ) !== 4 ) ) {
					if ( $userStatus === null ) {
						if ( ( $row->getInt( 'type', 0 ) !== 5 ) || $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="btn btn-block btn-sm btn-secondary gjButton gjButtonJoin">' . ( $row->getInt( '_invite_id', 0 ) ? CBTxt::T( 'Accept Group Invite' ) : CBTxt::T( 'Join Group' ) ) . '</a>';
						}

						if ( $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonReject">' . CBTxt::T( 'Reject Group Invite' ) . '</button>';
						}
					} elseif ( $userStatus === 0 ) {
						$buttons[]			=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel your pending join request to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonCancel">' . CBTxt::T( 'Cancel Group Join Request' ) . '</button>';
					}
				}

				$menuButton					=	null;

				if ( $isModerator || $rowOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjTabMenuItems">';

					if ( $isModerator || $rowOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
							if ( $isModerator ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModerator || $rowOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$menuAttr				=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu gjTabMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					$menuButton				=	'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
				}

				$return						.=			'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjTabGroup gjTabGroup' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
											.				'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutMd">'
											.					'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
											.						'<div class="position-absolute cbCanvasLayoutBackground">'
											.							$row->canvas( true, true, true )
											.						'</div>';

				if ( $menuButton ) {
					$return					.=						'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
											.							$menuButton
											.						'</div>';
				}

				$return						.=					'</div>'
											.					'<div class="position-relative cbCanvasLayoutBottom">'
											.						'<div class="position-absolute cbCanvasLayoutPhoto">'
											.							$row->logo( true, true, true )
											.						'</div>'
											.					'</div>'
											.					'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
											.						'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">';

				if ( ( $isModerator || $rowOwner ) && ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) ) {
					$return					.=							'<span class="fa fa-clock-o text-warning gjTabGroupIconPending" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return						.=							'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="text-large">' . htmlspecialchars( CBTxt::T( $row->getString( 'name' ) ) ) . '</a></strong>';

				if ( $row->getInt( 'category', 0 ) ) {
					$return					.=							'<div class="text-small text-truncate gjTabGroupCategory">'
											.								'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'category', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $row->getString( '_category_name' ) ) ) . '</a></strong>'
											.							'</div>';
				}

				$return						.=						'</div>'
											.						'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
											.							'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjTabGroupIconType"><span class="fa-before fa-globe"> ' . $row->type() . '</span></div>'
											.							( $row->getInt( 'type', 0 ) !== 4 ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjTabGroupIconUsers"><span class="fa-before fa-user"> ' . CBTxt::T( 'GROUP_USERS_COUNT', '%%COUNT%% User|%%COUNT%% Users', array( '%%COUNT%%' => $row->getInt( '_users', 0 ) ) ) . '</span></div>' : null )
											.							( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
											.						'</div>'
											.						( $content ? '<div class="m-2 cbCanvasLayoutContent gjTabGroupIntegrations">' . $content . '</div>' : null );

				if ( $row->getString( 'description' ) ) {
					$return					.=						'<div class="gjCanvasDescription gjTabGroupDescription">'
											.							cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
											.						'</div>';
				}

				if ( $buttons ) {
					$return					.=						'<div class="pl-2 pr-2 mb-2 cbCanvasLayoutButtons">'
											.							implode( ' ', $buttons )
											.						'</div>';
				}

				$return						.=					'</div>'
											.				'</div>'
											.			'</div>';
			}

			$return							.=		'</div>';

			if ( $params->getInt( 'tab_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return						.=		'<div class="mt-3 gjTabPaging">'
											.			$pageNav->getListLinks()
											.		'</div>';
			}
		} else {
			$return							.=		'<div class="gjTabEmpty">';

			if ( $searching ) {
				$return						.=			CBTxt::T( 'No group search results found.' );
			} elseif ( $viewer->getInt( 'id', 0 ) === $user->getInt( 'id', 0 ) ) {
				$return						.=			CBTxt::T( 'You have no groups.' );
			} else {
				$return						.=			CBTxt::T( 'This user has no groups.' );
			}

			$return							.=		'</div>';
		}

		$return								.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayTab', array( &$return, $rows, $viewer, $user, $tab ) );

		return $return;
	}
}