<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\PluginTable;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveModule
{

	/**
	 * render frontend categories module
	 *
	 * @param CategoryTable[]           $rows
	 * @param UserTable                 $user
	 * @param \Joomla\Registry\Registry $params
	 * @param PluginTable               $plugin
	 * @return string
	 */
	public static function showCategories( $rows, $user, $params, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		$return					=	null;

		if ( $rows ) {
			$return				.=	'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjModuleCategoryRows">';

			foreach ( $rows as $row ) {
				$cssClass		=	$row->getString( 'css' );
				$counters		=	array();
				$content		=	null;

				$_PLUGINS->trigger( 'gj_onDisplayCategory', array( &$row, &$counters, &$content, $user ) );

				$return			.=		'<div class="flex-grow-1 pb-3 pl-2 pr-2 gjModuleCategory gjModuleCategory' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
								.			'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutSm">'
								.				'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
								.					'<div class="position-absolute cbCanvasLayoutBackground">'
								.						$row->canvas( true, true, true )
								.					'</div>'
								.				'</div>'
								.				'<div class="position-relative cbCanvasLayoutBottom">'
								.					'<div class="position-absolute cbCanvasLayoutPhoto">'
								.						$row->logo( true, true, true )
								.					'</div>'
								.				'</div>'
								.				'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
								.					'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">'
								.						'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="text-large">' . CBTxt::T( $row->getString( 'name' ) ) . '</a></strong>'
								.					'</div>'
								.					'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
								.						'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjModuleCategoryIconGroups"><span class="fa-before fa-users"> ' . CBTxt::T( 'GROUPS_COUNT', '%%COUNT%% Group|%%COUNT%% Groups', array( '%%COUNT%%' => $row->getInt( '_groups', 0 ) ) ) . '</span></div>'
								.						( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
								.					'</div>'
								.					( $content ? '<div class="m-2 cbCanvasLayoutContent gjModuleCategoryIntegrations">' . $content . '</div>' : null );

				if ( $row->getString( 'description' ) ) {
					$return		.=					'<div class="gjCanvasDescription gjModuleCategoryDescription">'
								.						cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
								.					'</div>';
				}

				$return			.=				'</div>'
								.			'</div>'
								.		'</div>';
			}

			$return				.=	'</div>';
		}

		return $return;
	}

	/**
	 * render frontend groups module
	 *
	 * @param GroupTable[]              $rows
	 * @param UserTable                 $user
	 * @param \Joomla\Registry\Registry $params
	 * @param PluginTable               $plugin
	 * @return string
	 */
	public static function showGroups( $rows, $user, $params, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$return								=	null;

		if ( $rows ) {
			$return							.=	'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjModuleGroupRows">';

			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$userStatus					=	CBGroupJive::getGroupStatus( $user, $row );
				$cssClass					=	$row->getString( 'css' );

				$counters					=	array();
				$content					=	null;
				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayGroup', array( &$row, &$counters, &$content, &$menu, 'module', $user ) );

				$buttons					=	array();

				if ( $isModerator && ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) {
					$buttons[]				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-block btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Group' ) . '</a>';
				} elseif ( ( ! $rowOwner ) && ( $row->getInt( 'type', 0 ) !== 4 ) ) {
					if ( $userStatus === null ) {
						if ( ( $row->getInt( 'type', 0 ) !== 5 ) || $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'join', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) . '" class="btn btn-block btn-sm btn-secondary gjButton gjButtonJoin">' . ( $row->getInt( '_invite_id', 0 ) ? CBTxt::T( 'Accept Group Invite' ) : CBTxt::T( 'Join Group' ) ) . '</a>';
						}

						if ( $row->getInt( '_invite_id', 0 ) ) {
							$buttons[]		=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to reject all invites to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'reject', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonReject">' . CBTxt::T( 'Reject Group Invite' ) . '</button>';
						}
					} elseif ( $userStatus === 0 ) {
						$buttons[]			=	'<button type="button" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel your pending join request to this Group?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $row->getInt( 'id', 0 ), 'return' => CBGroupJive::getReturn() ) ) ) . '\'; })" class="btn btn-block btn-sm btn-light border gjButton gjButtonCancel">' . CBTxt::T( 'Cancel Group Join Request' ) . '</button>';
					}
				}

				$return						.=		'<div class="flex-grow-1 pb-3 pl-2 pr-2 gjModuleGroup gjModuleGroup' . $row->getInt( 'id', 0 ) . ( $cssClass ? ' ' . htmlspecialchars( $cssClass ) : null ) . '">'
											.			'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutSm">'
											.				'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
											.					'<div class="position-absolute cbCanvasLayoutBackground">'
											.						$row->canvas( true, true, true )
											.					'</div>'
											.				'</div>'
											.				'<div class="position-relative cbCanvasLayoutBottom">'
											.					'<div class="position-absolute cbCanvasLayoutPhoto">'
											.						$row->logo( true, true, true )
											.					'</div>'
											.				'</div>'
											.				'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
											.					'<div class="flex-grow-1 ml-2 mr-2 mt-2 text-truncate cbCanvasLayoutContent">';

				if ( ( $isModerator || $rowOwner ) && ( ( $row->getInt( 'published', 0 ) === -1 ) && $plugin->params->getInt( 'groups_create_approval', 0 ) ) ) {
					$return					.=						'<span class="fa fa-clock-o text-warning gjModuleGroupIconPending" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return						.=						'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="text-large">' . htmlspecialchars( CBTxt::T( $row->getString( 'name' ) ) ) . '</a></strong>';

				if ( $row->getInt( 'category', 0 ) ) {
					$return					.=						'<div class="text-small text-truncate gjModuleGroupCategory">'
											.							'<strong><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'category', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $row->getString( '_category_name' ) ) ) . '</a></strong>'
											.						'</div>';
				}

				$return						.=					'</div>'
											.					'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
											.						'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjModuleGroupIconType"><span class="fa-before fa-globe"> ' . $row->type() . '</span></div>'
											.						( $row->getInt( 'type', 0 ) !== 4 ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjModuleGroupIconUsers"><span class="fa-before fa-user"> ' . CBTxt::T( 'GROUP_USERS_COUNT', '%%COUNT%% User|%%COUNT%% Users', array( '%%COUNT%%' => $row->getInt( '_users', 0 ) ) ) . '</span></div>' : null )
											.						( $counters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $counters ) . '</div>' : null )
											.					'</div>'
											.					( $content ? '<div class="m-2 cbCanvasLayoutContent gjModuleGroupIntegrations">' . $content . '</div>' : null );

				if ( $row->getString( 'description' ) ) {
					$return					.=					'<div class="gjCanvasDescription gjModuleGroupDescription">'
											.						cbTooltip( null, $row->getString( 'description' ), null, null, null, '<span class="bg-white border rounded-circle p-1 pl-2 pr-2 text-small fa fa-info text-muted"></span>' )
											.					'</div>';
				}

				if ( $buttons ) {
					$return					.=					'<div class="pl-2 pr-2 mb-2 cbCanvasLayoutButtons">'
											.						implode( ' ', $buttons )
											.					'</div>';
				}

				$return						.=				'</div>'
											.			'</div>'
											.		'</div>';
			}

			$return							.=	'</div>';
		}

		return $return;
	}
}