<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJive\Table\InviteTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveInvites
{

	/**
	 * render frontend group invites
	 *
	 * @param InviteTable[]      $rows
	 * @param cbPageNav          $pageNav
	 * @param bool               $searching
	 * @param array              $input
	 * @param GroupTable         $group
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 * @return string
	 */
	public static function showInvites( $rows, $pageNav, $searching, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		$canCreateInvite				=	CBGroupJive::canCreateGroupContent( $user, $group, 'invites' );
		$canSearch						=	( $plugin->params->getInt( 'groups_invites_search', 0 ) && ( $searching || $pageNav->total ) );
		$return							=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayInvites', array( &$return, &$rows, $group, $user ) );

		$return							.=	'<div class="gjGroupInvites">';

		if ( $canCreateInvite || $canSearch ) {
			$return						.=		'<div class="row no-gutters mb-3 gjHeader gjGroupInvitesHeader">';

			if ( $canCreateInvite ) {
				$return					.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
										.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'new', 'group' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewInvite"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Invite' ) . '</a>'
										.			'</div>';
			}

			if ( $canSearch ) {
				$return					.=			'<div class="col-12 ' . ( ! $canCreateInvite ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
										.				'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupInvitesSearchForm" class="m-0 gjGroupInvitesSearchForm">'
										.					'<div class="input-group">'
										.						$input['search']
										.						'<div class="input-group-append">'
										.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
										.						'</div>'
										.					'</div>'
										.				'</form>'
										.			'</div>';
			}

			$return						.=		'</div>';
		}

		$return							.=		'<div class="table-responsive gjGroupInvitesRows">'
										.			'<table class="table table-hover">'
										.				'<thead>'
										.					'<tr>'
										.						'<th>' . CBTxt::T( 'To' ) . '</th>'
										.						'<th style="width: 25%;" class="d-none d-sm-table-cell">' . CBTxt::T( 'Date' ) . '</th>'
										.						'<th style="width: 5%;" class="text-center">' . CBTxt::T( 'Status' ) . '</th>'
										.						'<th style="width: 1%;"></th>'
										.					'</tr>'
										.				'</thead>'
										.				'<tbody>';

		if ( $rows ) {
			foreach ( $rows as $row ) {
				$menu					=	array();

				$_PLUGINS->trigger( 'gj_onDisplayInvite', array( &$row, &$menu, $group, $user ) );

				if ( $row->getInt( 'user', 0 ) ) {
					$toUser				=	CBuser::getInstance( $row->getInt( 'user', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
				} else {
					$toUser				=	'<a href="mailto:' . htmlspecialchars( $row->getString( 'email' ) ) . '">' . $row->getString( 'email' ) . '</a>';
				}

				$return					.=					'<tr>'
										.						'<td class="align-middle text-wrap">' . $toUser . '</td>'
										.						'<td style="width: 25%;" class="align-middle d-none d-sm-table-cell">'
										.							( $row->invited() ? '<div class="text-info" title="' . htmlspecialchars( CBTxt::T( 'Invited' ) ) . '">' . cbFormatDate( $row->getString( 'invited' ) ) . '</div>' : '<div class="text-warning">' . CBTxt::T( 'Please Resend' ) . '</div>' )
										.							( $row->accepted() ? '<div class="text-success" title="' . htmlspecialchars( CBTxt::T( 'Accepted' ) ) . '">' . cbFormatDate( $row->getString( 'accepted' ) ) . '</div>' : null )
										.						'</td>'
										.						'<td style="width: 5%;" class="align-middle text-center clearfix">';

				if ( $row->accepted() ) {
					$return				.=							'<span class="gjInviteIconAccepted fa fa-check text-success" title="' . htmlspecialchars( CBTxt::T( 'Accepted' ) ) . '"></span>';
				} elseif ( $row->invited() ) {
					$return				.=							'<span class="gjInviteIconPending fa fa-clock-o text-warning" title="' . htmlspecialchars( CBTxt::T( 'Pending' ) ) . '"></span>';
				} else {
					$return				.=							'<span class="gjInviteIconResent fa fa-warning text-danger" title="' . htmlspecialchars( CBTxt::T( 'Resend' ) ) . '"></span>';
				}

				$return					.=						'</td>';

				$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjInviteMenuItems">';

				if ( $row->canResend() ) {
					$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'send', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-share-square-o"></span> ' . CBTxt::T( 'Resend' ) . '</a></li>';
				}

				if ( ! $row->accepted() ) {
					$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';
				}

				if ( $menu ) {
					$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
				}

				$menuItems				.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Invite?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>'
										.	'</ul>';

				$return					.=						'<td style="width: 1%;" class="p-0 align-middle">'
										.							cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu gjInviteMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' )
										.						'</td>'
										.					'</tr>';
			}
		} else {
			$return						.=					'<tr>'
										.						'<td colspan="4" class="gjGroupInvitesEmpty">';

			if ( $searching ) {
				$return					.=							CBTxt::T( 'No group invite search results found.' );
			} else {
				$return					.=							CBTxt::T( 'You currently have no invites in this group.' );
			}

			$return						.=						'</td>'
										.					'</tr>';
		}

		$return							.=				'</tbody>';

		if ( $plugin->params->getInt( 'groups_invites_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
			$return						.=				'<tfoot>'
										.					'<tr>'
										.						'<td colspan="4" class="gjGroupInvitesPaging">'
										.							$pageNav->getListLinks()
										.						'</td>'
										.					'</tr>'
										.				'</tfoot>';
		}

		$return							.=			'</table>'
										.		'</div>'
										.	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayInvites', array( &$return, &$rows, $group, $user ) );

		return $return;
	}
}