<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\InviteTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveInviteEdit
{

	/**
	 * render frontend invite edit
	 *
	 * @param InviteTable        $row
	 * @param array              $input
	 * @param GroupTable         $group
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showInviteEdit( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$js							=	"$( '.gjInviteConnection' ).on( 'change', function() {"
									.		"if ( $( this ).val() != 0 ) {"
									.			"$( '#gjInviteTo' ).addClass( 'hidden' );"
									.		"} else {"
									.			"$( '#gjInviteTo' ).removeClass( 'hidden' );"
									.		"}"
									.	"});";

		$_CB_framework->outputCbJQuery( $js );

		$pageTitle					=	( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Edit Invite' ) : CBTxt::T( 'New Invite' ) );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$return						=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayInviteEdit', array( &$return, &$row, &$input, $group, $user ) );

		$return						.=	'<div class="gjInviteEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'save', 'group' => ( ! $row->getInt( 'id', 0 ) ? $group->getInt( 'id' ) : null ), 'id' => $row->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjInviteEditForm" id="gjInviteEditForm" class="form-auto m-0 cb_form gjInviteEditForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjInviteEditTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null );

		if ( ! $row->getInt( 'id', 0 ) ) {
			$inviteConn				=	( $plugin->params->getInt( 'groups_invites_list', 0 ) && $input['list'] );

			if ( $inviteConn ) {
				$return				.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="to" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'To' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['list']
									.					getFieldIcons( null, null, null, CBTxt::T( 'Select a connection to invite.' ) )
									.				'</div>'
									.			'</div>';
			}

			$return					.=			'<div id="gjInviteTo" class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				( ! $inviteConn ? '<label for="to" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'To' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $inviteConn ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['to']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'GROUP_INVITE_BY', 'Input the recipient as [invite_by].', array( '[invite_by]' => implode( ', ', $input['invite_by'] ) ) ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="message" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Message' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['message']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input private message to include with the invite.' ) )
									.				'</div>'
									.			'</div>';

		if ( ( ! $isModerator ) && $plugin->params->getInt( 'groups_invites_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<input type="submit" value="' . htmlspecialchars( ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Invite' ) : CBTxt::T( 'Create Invite' ) ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.					' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.				'</div>'
									.			'</div>'
									.			( ! $row->getInt( 'id', 0 ) ? '<input type="hidden" id="group" name="group" value="' . $group->getInt( 'id', 0 ) . '" />' : null )
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayInviteEdit', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}