<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJive\Trigger;

use CB\Plugin\GroupJive\CBGroupJive;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\Gallery;

defined('CBLIB') or die();

class GalleryTrigger extends \cbPluginHandler
{

	/**
	 * @return bool
	 */
	private function isCompatible()
	{
		global $_PLUGINS;

		static $compatible		=	null;

		if ( $compatible === null ) {
			$plugin				=	$_PLUGINS->getLoadedPlugin( 'user', 'cbgallery' );

			if ( $plugin ) {
				$pluginVersion	=	str_replace( '+build.', '+', $_PLUGINS->getPluginVersion( $plugin, true ) );

				$compatible		=	( version_compare( $pluginVersion, '2.0.0', '>=' ) && version_compare( $pluginVersion, '3.0.0', '<' ) );
			}
		}

		return $compatible;
	}

	/**
	 * @param bool      $access
	 * @param UserTable $user
	 * @param Gallery   $gallery
	 */
	public function createFolderAccess( &$access, $user, $gallery )
	{
		if ( ( ! $this->isCompatible() ) || ( ! preg_match( '/^groupjive\.group\.(\d+)(?:\.([a-zA-Z]+))?/', $gallery->asset(), $matches ) ) ) {
			return;
		}

		$group			=	CBGroupJive::getGroup( (int) $matches[1] );

		if ( ! $group->getInt( 'id', 0 ) ) {
			return;
		}

		if ( $group->getInt( 'published', 0 ) === -1 ) {
			$access		=	false;
		} else {
			$access		=	( ( $group->getInt( 'user_id', 0 ) === $user->getInt( 'id', 0 ) ) || ( CBGroupJive::getGroupStatus( $user, $group ) >= 1 ) );
		}
	}

	/**
	 * @param bool      $access
	 * @param string    $type
	 * @param string    $method
	 * @param UserTable $user
	 * @param Gallery   $gallery
	 */
	public function createItemAccess( &$access, $type, $method, $user, $gallery )
	{
		if ( ( ! $this->isCompatible() ) || ( ! preg_match( '/^groupjive\.group\.(\d+)(?:\.([a-zA-Z]+))?/', $gallery->asset(), $matches ) ) ) {
			return;
		}

		$group			=	CBGroupJive::getGroup( (int) $matches[1] );

		if ( ! $group->getInt( 'id', 0 ) ) {
			return;
		}

		if ( $group->getInt( 'published', 0 ) === -1 ) {
			$access		=	false;
		} else {
			$access		=	( ( $group->getInt( 'user_id', 0 ) === $user->getInt( 'id', 0 ) ) || ( CBGroupJive::getGroupStatus( $user, $group ) >= 1 ) );
		}
	}

	/**
	 * @param bool      $access
	 * @param UserTable $user
	 * @param Gallery   $gallery
	 */
	public function moderateAccess( &$access, $user, $gallery )
	{
		if ( ( ! $this->isCompatible() ) || ( ! preg_match( '/^groupjive\.group\.(\d+)(?:\.([a-zA-Z]+))?/', $gallery->asset(), $matches ) ) ) {
			return;
		}

		$group			=	CBGroupJive::getGroup( (int) $matches[1] );

		if ( ! $group->getInt( 'id', 0 ) ) {
			return;
		}

		if ( $group->getInt( 'published', 0 ) === -1 ) {
			$access		=	false;
		} else {
			$access		=	( ( $group->getInt( 'user_id', 0 ) === $user->getInt( 'id', 0 ) ) || ( CBGroupJive::getGroupStatus( $user, $group ) >= 2 ) );
		}
	}

	/**
	 * @param string $asset
	 * @param mixed  $source
	 */
	public function assetSource( $asset, &$source )
	{
		if ( ! preg_match( '/^(?:notification\.(\d+)\.)?groupjive\.group\.(\d+)(?:\.([a-zA-Z]+))?/', $asset, $matches ) ) {
			return;
		}

		if ( isset( $matches[3] ) && ( ! in_array( $matches[3], array( 'join', 'leave', 'create', 'invite' ), true ) ) ) {
			return;
		}

		$group		=	CBGroupJive::getGroup( (int) $matches[2] );

		if ( ! $group->getInt( 'id', 0 ) ) {
			return;
		}

		$source		=	$group;
	}
}