<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Application\Application;
use CBLib\Database\Table\Table;
use CB\Database\Table\PluginTable;
use CB\Database\Table\TabTable;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJive/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjive_install()
{
	global $_CB_database, $_PLUGINS;

	// Uninstall the old integrations to avoid conflicts:
	$integrations									=	array(	'cbgroupjiveabout', 'cbgroupjiveevents', 'cbgroupjivefile',
																'cbgroupjiveforums', 'cbgroupjivephoto', 'cbgroupjivevideo',
																'cbgroupjivewall', 'cbgroupjiveauto'
															);

	foreach ( $integrations as $integration ) {
		$plugin										=	new PluginTable();

		$plugin->load( array( 'element' => $integration ) );

		if ( $plugin->getInt( 'id', 0 ) && ( ! is_dir( $_PLUGINS->getPluginPath( $plugin ) . '/xml' ) ) ) {
			$plugin->delete();
		}
	}

	// Migrate categories:
	$table											=	'#__groupjive_categories';
	$fields											=	$_CB_database->getTableFields( $table );
	$migrate										=	false;

	if ( isset( $fields[$table]['parent'] ) ) {
		$migrate									=	true;

		$query										=	'SELECT *'
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_categories' );
		$_CB_database->setQuery( $query );
		$categories									=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__groupjive_categories', 'id' ) );

		/** @var $categories Table[] */
		foreach ( $categories as $category ) {
			$category->set( 'access', ( $category->getInt( 'access', 0 ) === -2 ? 1 : ( $category->getInt( 'access', 0 ) === -1 ? 2 : Application::CmsPermissions()->convertOldGroupToViewAccessLevel( $category->getInt( 'access', 0 ), 'CB GroupJive: Category Access - ' . $category->getInt( 'id', 0 ) ) ) ) );
			$category->set( 'create_access', ( ! $category->getInt( 'create', 0 ) ? -1 : ( $category->getInt( 'create_access', 0 ) === -1 ? 2 : Application::CmsPermissions()->convertOldGroupToViewAccessLevel( $category->getInt( 'create_access', 0 ), 'CB GroupJive: Category Create Access - ' . $category->getInt( 'id', 0 ) ) ) ) );

			$categoryParams							=	new Registry( $category->getRaw( 'params', array() ) );

			// CB GroupJive Forums:
			$categoryParams->set( 'forums', $categoryParams->getInt( 'forum_show', 0 ) );

			$category->set( 'params', $categoryParams->asJson() );

			$category->store();
		}

		// Remove the old columns:
		$_CB_database->dropColumn( $table, 'parent' );
		$_CB_database->dropColumn( $table, 'create' );
		$_CB_database->dropColumn( $table, 'nested' );
		$_CB_database->dropColumn( $table, 'nested_access' );
	}

	// Migrate groups:
	$table											=	'#__groupjive_groups';
	$fields											=	$_CB_database->getTableFields( $table );

	if ( isset( $fields[$table]['parent'] ) ) {
		$migrate									=	true;

		$query										=	'SELECT *'
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' );
		$_CB_database->setQuery( $query );
		$groups										=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__groupjive_groups', 'id' ) );

		/** @var $groups Table[] */
		foreach ( $groups as $group ) {
			$groupParams							=	new Registry( $group->getRaw( 'params', array() ) );

			// Core:
			$groupParams->set( 'invites', ( $group->getInt( 'invite', 0 ) > 0 ? 0 : 1 ) );

			// CB GroupJive Events:
			$groupParams->set( 'events', ( $groupParams->getInt( 'events_approve', 0 ) ? 2 : $groupParams->getInt( 'events_show', 0 ) ) );

			// CB GroupJive File:
			$groupParams->set( 'file', ( $groupParams->getInt( 'file_approve', 0 ) ? 2 : $groupParams->getInt( 'file_show', 0 ) ) );

			// CB GroupJive Forums:
			$groupParams->set( 'forums', $groupParams->getInt( 'forum_show', 0 ) );

			// CB GroupJive Photo:
			$groupParams->set( 'photo', ( $groupParams->getInt( 'photo_approve', 0 ) ? 2 : $groupParams->getInt( 'photo_show', 0 ) ) );

			// CB GroupJive Video:
			$groupParams->set( 'video', ( $groupParams->getInt( 'video_approve', 0 ) ? 2 : $groupParams->getInt( 'video_show', 0 ) ) );

			// CB GroupJive Wall:
			$groupParams->set( 'wall', ( $groupParams->getInt( 'wall_approve', 0 ) ? 2 : $groupParams->getInt( 'wall_show', 0 ) ) );

			$group->set( 'params', $groupParams->asJson() );

			$group->store();
		}

		// Remove the old columns:
		$_CB_database->dropColumn( $table, 'parent' );
		$_CB_database->dropColumn( $table, 'access' );
		$_CB_database->dropColumn( $table, 'invite' );
		$_CB_database->dropColumn( $table, 'users' );
		$_CB_database->dropColumn( $table, 'nested' );
		$_CB_database->dropColumn( $table, 'nested_access' );
	}

	// Migrate notifications:
	$table											=	'#__groupjive_notifications';
	$fields											=	$_CB_database->getTableFields( $table );

	if ( isset( $fields[$table]['type'] ) ) {
		$migrate									=	true;

		// Delete notification types no longer supported:
		$query										=	'DELETE'
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_notifications' )
													.	"\n WHERE " . $_CB_database->NameQuote( 'type' ) . " != " . $_CB_database->Quote( 'group' );
		$_CB_database->setQuery( $query );
		$_CB_database->query();

		// Migration notification parameters:
		$query										=	'SELECT *'
													.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_notifications' );
		$_CB_database->setQuery( $query );
		$notifications								=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__groupjive_notifications', 'id' ) );

		/** @var $notifications Table[] */
		foreach ( $notifications as $notification ) {
			if ( ( $notification->getString( 'type' ) === 'group' ) && $notification->getInt( 'item', 0 ) ) {
				$notification->set( 'group', $notification->getInt( 'item', 0 ) );

				$notificationParams					=	new Registry( $notification->getRaw( 'params', array() ) );

				// Core:
				$notificationParams->set( 'user_join', $notificationParams->getInt( 'group_userjoin', 0 ) );
				$notificationParams->set( 'user_leave', $notificationParams->getInt( 'group_userleave', 0 ) );
				$notificationParams->set( 'user_approve', $notificationParams->getInt( 'group_userapprove', 0 ) );
				$notificationParams->set( 'invite_accept', $notificationParams->getInt( 'group_inviteaccept', 0 ) );

				// CB GroupJive Events:
				$notificationParams->set( 'event_new', $notificationParams->getInt( 'group_eventnew', 0 ) );
				$notificationParams->set( 'event_approve', $notificationParams->getInt( 'group_eventapprove', 0 ) );
				$notificationParams->set( 'event_attend', $notificationParams->getInt( 'group_eventyes', 0 ) );
				$notificationParams->set( 'event_unattend', $notificationParams->getInt( 'group_eventno', 0 ) );

				// CB GroupJive File:
				$notificationParams->set( 'file_new', $notificationParams->getInt( 'group_filenew', 0 ) );
				$notificationParams->set( 'file_approve', $notificationParams->getInt( 'group_fileapprove', 0 ) );

				// CB GroupJive Photo:
				$notificationParams->set( 'photo_new', $notificationParams->getInt( 'group_photonew', 0 ) );
				$notificationParams->set( 'photo_approve', $notificationParams->getInt( 'group_photoapprove', 0 ) );

				// CB GroupJive Video:
				$notificationParams->set( 'video_new', $notificationParams->getInt( 'group_videonew', 0 ) );
				$notificationParams->set( 'video_approve', $notificationParams->getInt( 'group_videoapprove', 0 ) );

				// CB GroupJive Wall:
				$notificationParams->set( 'wall_new', $notificationParams->getInt( 'group_wallnew', 0 ) );
				$notificationParams->set( 'wall_approve', $notificationParams->getInt( 'group_wallapprove', 0 ) );
				$notificationParams->set( 'wall_reply', $notificationParams->getInt( 'group_wallreply', 0 ) );

				$notification->set( 'params', $notificationParams->asJson() );

				$notification->store();
			}
		}

		// Remove the old columns:
		$_CB_database->dropColumn( $table, 'type' );
		$_CB_database->dropColumn( $table, 'item' );
	}

	if ( $migrate ) {
		// Migrate global parameters:
		$plugin										=	new PluginTable();

		$plugin->load( array( 'element' => 'cbgroupjive' ) );

		$pluginParams								=	new Registry( $plugin->getRaw( 'params', array() ) );

		// Notifications:
		$pluginParams->set( 'notifications', $pluginParams->getInt( 'general_notifications', 0 ) );
		$pluginParams->set( 'notifications_notifyby', ( $pluginParams->getInt( 'general_notifyby', 0 ) < 4 ? 2 : 1 ) );
		$pluginParams->set( 'notifications_default_user_join', $pluginParams->getInt( 'notifications_group_userjoin', 0 ) );
		$pluginParams->set( 'notifications_default_user_leave', $pluginParams->getInt( 'notifications_group_userleave', 0 ) );
		$pluginParams->set( 'notifications_default_user_approve', $pluginParams->getInt( 'notifications_group_userapprove', 0 ) );
		$pluginParams->set( 'notifications_default_invite_accept', $pluginParams->getInt( 'notifications_group_inviteaccept', 0 ) );

		// Categories:
		$pluginParams->set( 'categories_paging', $pluginParams->getInt( 'overview_paging', 0 ) );
		$pluginParams->set( 'categories_limit', $pluginParams->getInt( 'overview_limit' ) );
		$pluginParams->set( 'categories_search', $pluginParams->getInt( 'overview_search', 0 ) );

		switch( $pluginParams->getInt( 'overview_orderby', 0 ) ) {
			case 7:
				$orderBy							=	5;
				break;
			case 8:
				$orderBy							=	6;
				break;
			case 5:
				$orderBy							=	3;
				break;
			case 6:
				$orderBy							=	4;
				break;
			case 1:
			case 2:
				$orderBy							=	$pluginParams->getInt( 'overview_orderby', 0 );
				break;
			case 3:
			case 4:
			case 9:
			case 10:
			default:
				$orderBy							=	1;
				break;
		}

		$pluginParams->set( 'categories_orderby', $orderBy );
		$pluginParams->set( 'categories_groups_paging', $pluginParams->getInt( 'category_groups_paging', 0 ) );
		$pluginParams->set( 'categories_groups_limit', $pluginParams->getInt( 'category_groups_limit' ) );
		$pluginParams->set( 'categories_groups_search', $pluginParams->getInt( 'category_groups_search', 0 ) );
		$pluginParams->set( 'categories_groups_orderby', ( $pluginParams->getInt( 'category_groups_orderby', 0 ) > 8 ? 4 : $pluginParams->getInt( 'category_groups_orderby', 0 ) ) );

		// Groups:
		$pluginParams->set( 'groups_create_access', ( ! $pluginParams->getInt( 'group_create', 0 ) ? -1 : ( $pluginParams->getInt( 'group_create_access', 0 ) === -1 ? 2 : Application::CmsPermissions()->convertOldGroupToViewAccessLevel( $pluginParams->getInt( 'group_create_access', 0 ), 'CB GroupJive: Groups Create Access' ) ) ) );
		$pluginParams->set( 'groups_create_limit', $pluginParams->getInt( 'group_limit' ) );
		$pluginParams->set( 'groups_create_approval', $pluginParams->getInt( 'group_approve', 0 ) );
		$pluginParams->set( 'groups_create_captcha', $pluginParams->getInt( 'group_captcha', 0 ) );
		$pluginParams->set( 'groups_message', $pluginParams->getInt( 'group_message', 0 ) );
		$pluginParams->set( 'groups_message_captcha', $pluginParams->getInt( 'group_message_captcha', 0 ) );
		$pluginParams->set( 'groups_users_paging', $pluginParams->getInt( 'group_users_paging', 0 ) );
		$pluginParams->set( 'groups_users_limit', $pluginParams->getInt( 'group_users_limit' ) );
		$pluginParams->set( 'groups_users_search', $pluginParams->getInt( 'group_users_search', 0 ) );
		$pluginParams->set( 'groups_invites_display', $pluginParams->getInt( 'group_invites_display', 0 ) );
		$pluginParams->set( 'groups_invites_by', $pluginParams->getString( 'group_invites_by' ) );
		$pluginParams->set( 'groups_invites_list', $pluginParams->getInt( 'group_invites_list', 0 ) );
		$pluginParams->set( 'groups_invites_accept', $pluginParams->getInt( 'group_invites_accept', 0 ) );
		$pluginParams->set( 'groups_invites_captcha', $pluginParams->getInt( 'group_invites_captcha', 0 ) );
		$pluginParams->set( 'groups_invites_paging', $pluginParams->getInt( 'group_invites_paging', 0 ) );
		$pluginParams->set( 'groups_invites_limit', $pluginParams->getInt( 'group_invites_limit' ) );
		$pluginParams->set( 'groups_invites_search', $pluginParams->getInt( 'group_invites_search', 0 ) );
		$pluginParams->set( 'groups_paging', $pluginParams->getInt( 'group_all_paging', 0 ) );
		$pluginParams->set( 'groups_limit', $pluginParams->getInt( 'group_all_limit' ) );
		$pluginParams->set( 'groups_search', $pluginParams->getInt( 'group_all_search', 0 ) );
		$pluginParams->set( 'groups_orderby', ( $pluginParams->getInt( 'group_all_orderby', 0 ) > 8 ? 4 : $pluginParams->getInt( 'group_all_orderby', 0 ) ) );

		$plugin->set( 'params', $pluginParams->asJson() );

		$plugin->store();

		// Migrate the old auto fields to core GJ:
		$query										=	'UPDATE '. $_CB_database->NameQuote( '#__comprofiler_fields' )
													.	"\n SET " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'groupautojoin' )
													.	', ' . $_CB_database->NameQuote( 'pluginid' ) . ' = ' . $plugin->getInt( 'id', 0 )
													.	"\n WHERE " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'cbgjautojoin' );
		$_CB_database->setQuery( $query );
		$_CB_database->query();

		// Migrate tab parameters:
		$tab										=	new TabTable();

		$tab->load( array( 'pluginclass' => 'cbgjTab' ) );

		$tabParams									=	new Registry( $tab->getRaw( 'params', array() ) );

		$tabParams->set( 'tab_paging', $pluginParams->getInt( 'group_tab_paging', 0 ) );
		$tabParams->set( 'tab_limit', $pluginParams->getInt( 'group_tab_limit' ) );
		$tabParams->set( 'tab_search', $pluginParams->getInt( 'group_tab_search', 0 ) );
		$tabParams->set( 'tab_orderby', ( $pluginParams->getInt( 'group_tab_orderby', 0 ) > 8 ? 4 : $pluginParams->getInt( 'group_tab_orderby', 0 ) ) );

		$tab->set( 'params', $tabParams->asJson() );

		$tab->store();
	}

	// Fix old non-NULL dates
	$query	=	'UPDATE '. $_CB_database->NameQuote( '#__groupjive_invites' )
			.	"\n SET " . $_CB_database->NameQuote( 'invited' ) . " = NULL"
			.	"\n WHERE " . $_CB_database->NameQuote( 'invited' ) . " = 0";
	$_CB_database->setQuery( $query );
	$_CB_database->query();

	$query	=	'UPDATE '. $_CB_database->NameQuote( '#__groupjive_invites' )
			.	"\n SET " . $_CB_database->NameQuote( 'accepted' ) . " = NULL"
			.	"\n WHERE " . $_CB_database->NameQuote( 'accepted' ) . " = 0";
	$_CB_database->setQuery( $query );
	$_CB_database->query();
}