<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Plugin\GroupJive\CBGroupJive;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_database, $_PLUGINS;

if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
	echo 'CB not installed'; return;
}

include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

cbimport( 'cb.html' );
cbimport( 'language.front' );

$_PLUGINS->loadPluginGroup( 'user' );

$gjPlugin								=	$_PLUGINS->getLoadedPlugin( 'user', 'cbgroupjive' );

if ( ! $gjPlugin ) {
	echo 'CB GroupJive not installed'; return;
}

outputCbJs();
outputCbTemplate();

if ( ! $gjPlugin->params instanceof ParamsInterface ) {
	$gjPlugin->params					=	new Registry( $gjPlugin->params );
}

$integrations							=	$_PLUGINS->trigger( 'gj_onModuleDisplay', array( $params ) );
$return									=	null;

if ( is_array( $integrations ) && $integrations ) {
	$return								=	implode( '', $integrations );
} else {
	$user								=	CBuser::getMyUserDataInstance();
	$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );

	CBGroupJive::getTemplate( 'module' );

	$mode								=	$params->get( 'groupjive_mode', 'latest_groups' );
	$limit								=	(int) $params->get( 'groupjive_limit', 10 );

	$includeCategories					=	$params->get( 'groupjive_include_categories' );
	$includeGroups						=	$params->get( 'groupjive_include_groups' );

	if ( ! is_array( $includeCategories ) ) {
		if ( $includeCategories ) {
			$includeCategories			=	explode( ',', $includeCategories );
		} else {
			$includeCategories			=	array();
		}
	}

	if ( ! is_array( $includeGroups ) ) {
		if ( $includeGroups ) {
			$includeGroups				=	explode( ',', $includeGroups );
		} else {
			$includeGroups				=	array();
		}
	}

	$excludeCategories					=	$params->get( 'groupjive_exclude_categories' );
	$excludeGroups						=	$params->get( 'groupjive_exclude_groups' );

	if ( ! is_array( $excludeCategories ) ) {
		if ( $excludeCategories ) {
			$excludeCategories			=	explode( ',', $excludeCategories );
		} else {
			$excludeCategories			=	array();
		}
	}

	if ( ! is_array( $excludeGroups ) ) {
		if ( $excludeGroups ) {
			$excludeGroups				=	explode( ',', $excludeGroups );
		} else {
			$excludeGroups				=	array();
		}
	}

	switch( $mode ) {
		case 'categories_asc':
		case 'categories_desc':
		case 'popular_categories':
		case 'random_categories':
			switch ( $mode ) {
				case 'random_categories':
					$orderBy			=	' RAND()';
					break;
				case 'popular_categories':
					$orderBy			=	$_CB_database->NameQuote( '_groups' ) . ' DESC';
					break;
				case 'categories_desc':
					$orderBy			=	'c.' . $_CB_database->NameQuote( 'ordering' ) . ' DESC';
					break;
				case 'categories_asc':
				default:
					$orderBy			=	'c.' . $_CB_database->NameQuote( 'ordering' ) . ' ASC';
					break;
			}

			$groups						=	'SELECT COUNT(*)'
										.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
										.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
										.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' );

			if ( $user->getInt( 'id', 0 ) && ( ! $isModerator ) ) {
				$groups					.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
										.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
										.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
										.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
										.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
										.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
										.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
										.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
			}

			$groups						.=	"\n WHERE g." . $_CB_database->NameQuote( 'category' ) . " = c." . $_CB_database->NameQuote( 'id' )
										.	( $includeGroups ? "\n AND g." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $includeGroups ) : null )
										.	( $excludeGroups ? "\n AND g." . $_CB_database->NameQuote( 'id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $excludeGroups ) : null )
										.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
										.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
										.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

			if ( ! $isModerator ) {
				if ( $user->getInt( 'id', 0 ) ) {
					$groups				.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
										.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
										.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
										.		' OR u.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
										.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
				} else {
					$groups				.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
				}
			}

			$query						=	'SELECT c.*'
										.	', ( ' . $groups . ' ) AS _groups'
										.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c";

			if ( ! $isModerator ) {
				$query					.=	"\n WHERE c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND c." . $_CB_database->NameQuote( 'access' ) . " IN " . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) )
										.	( $includeCategories ? "\n AND c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $includeCategories ) : null )
										.	( $excludeCategories ? "\n AND c." . $_CB_database->NameQuote( 'id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $excludeCategories ) : null );
			} elseif ( $includeCategories || $excludeCategories ) {
				$query					.=	( $includeCategories ? "\n WHERE c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $includeCategories ) : null )
										.	"\n " . ( $includeCategories ? "AND" : "WHERE" ) . " c." . $_CB_database->NameQuote( 'id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $excludeCategories );
			}

			$query						.=	"\n ORDER BY " . $orderBy;
			if ( $limit ) {
				$_CB_database->setQuery( $query, 0, $limit );
			} else {
				$_CB_database->setQuery( $query );
			}
			$rows						=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\CategoryTable', array( $_CB_database ) );

			if ( $rows ) {
				CBGroupJive::prefetchCategories( $rows );
				CBGroupJive::preFetchUsers( $rows );

				$return					=	HTML_groupjiveModule::showCategories( $rows, $user, $params, $gjPlugin );
			}
			break;
		case 'popular_groups':
		case 'random_groups':
		case 'latest_groups':
		case 'oldest_groups':
		case 'my_groups':
		case 'owned_groups':
		case 'joined_groups':
		case 'invited_groups':
		case 'groups_approval':
		default:
			$orderBy					=	'g.' . $_CB_database->NameQuote( 'date' ) . ' DESC';

			switch ( $mode ) {
				case 'groups_approval':
					if ( ! $isModerator ) {
						break 2;
					}
					break;
				case 'invited_groups':
					if ( ! $user->getInt( 'id', 0 ) ) {
						break 2;
					}
					break;
				case 'joined_groups':
					if ( ! $user->getInt( 'id', 0 ) ) {
						break 2;
					}
					break;
				case 'owned_groups':
					if ( ! $user->getInt( 'id', 0 ) ) {
						break 2;
					}
					break;
				case 'my_groups':
					if ( ! $user->getInt( 'id', 0 ) ) {
						break 2;
					}
					break;
				case 'popular_groups':
					$orderBy			=	$_CB_database->NameQuote( '_users' ) . ' DESC';
					break;
				case 'oldest_groups':
					$orderBy			=	'g.' . $_CB_database->NameQuote( 'date' ) . ' ASC';
					break;
				case 'random_groups':
					$orderBy			=	' RAND()';
					break;
			}

			$sqlModes					=	( $mode === 'my_groups' ? array( 'owned_groups', 'joined_groups', 'invited_groups' ) : array( $mode ) );

			$users						=	'SELECT COUNT(*)'
										.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS uc"
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS uccb"
										.	' ON uccb.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS ucj"
										.	' ON ucj.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
										.	"\n WHERE uc." . $_CB_database->NameQuote( 'group' ) . " = g." . $_CB_database->NameQuote( 'id' )
										.	"\n AND uccb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
										.	"\n AND uccb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
										.	"\n AND ucj." . $_CB_database->NameQuote( 'block' ) . " = 0";

			if ( ! $isModerator ) {
				if ( $user->getInt( 'id', 0 ) ) {
					$users				.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
										.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' >= 2'
										.		' OR uc.' . $_CB_database->NameQuote( 'status' ) . ' >= 1 )';
				} else {
					$users				.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " >= 1";
				}
			}

			if ( ! $gjPlugin->params->getInt( 'groups_users_owner', 1 ) ) {
				$users					.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " != 4";
			}

			$queries					=	array();

			foreach ( $sqlModes as $sqlMode ) {
				if ( ( ! $user->getInt( 'id', 0 ) ) && in_array( $sqlMode, array( 'groups_approval', 'invited_groups', 'joined_groups', 'owned_groups' ) ) ) {
					continue;
				}

				$query					=	'SELECT g.*'
										.	', c.' . $_CB_database->NameQuote( 'name' ) . ' AS _category_name'
										.	', ' . ( $user->getInt( 'id', 0 ) && ( ( ! $isModerator ) || in_array( $sqlMode, array( 'popular_groups', 'random_groups', 'latest_groups', 'oldest_groups', 'joined_groups' ) ) ) ? 'u.' . $_CB_database->NameQuote( 'status' ) : 'NULL' ) . ' AS _user_status'
										.	', ' . ( $user->getInt( 'id', 0 ) && in_array( $sqlMode, array( 'all', 'invited_groups' ) ) ? 'i.' . $_CB_database->NameQuote( 'id' ) : 'NULL' ) . ' AS _invite_id'
										.	', ( ' . $users . ' ) AS _users'
										.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
										.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
										.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
										.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );

				if ( $user->getInt( 'id', 0 ) && ( ( ! $isModerator ) || in_array( $sqlMode, array( 'popular_groups', 'random_groups', 'latest_groups', 'oldest_groups', 'joined_groups' ) ) ) ) {
					$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
										.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
										.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
										.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3';
				}

				if ( $user->getInt( 'id', 0 ) && in_array( $sqlMode, array( 'popular_groups', 'random_groups', 'latest_groups', 'oldest_groups', 'invited_groups' ) ) ) {
					$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
										.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
										.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
										.	' AND ( ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
										.	' AND i.' . $_CB_database->NameQuote( 'email' ) . ' != "" )'
										.	' OR ( i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 )
										.	' AND i.' . $_CB_database->NameQuote( 'user' ) . ' > 0 ) )';
				}

				$query					.=	"\n WHERE cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
										.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
										.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

				switch ( $sqlMode ) {
					case 'groups_approval':
						$query			.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = -1";
						break;
					case 'invited_groups':
						$query			.=	"\n AND i." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

						if ( ! $isModerator ) {
							$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
										.		( $gjPlugin->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						}
						break;
					case 'joined_groups':
						$query			.=	"\n AND u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

						if ( ! $isModerator ) {
							$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
										.		( $gjPlugin->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						}
						break;
					case 'owned_groups':
						$query			.=	"\n AND g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

						if ( ! $isModerator ) {
							$query		.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
										.		( $gjPlugin->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						}
						break;
					default:
						if ( ! $isModerator ) {
							if ( $user->getInt( 'id', 0 ) ) {
								$query	.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
										.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
										.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
										.		' OR u.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
										.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )'
										.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
										.		( $gjPlugin->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
							} else {
								$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3"
										.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
										.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
										.		( $gjPlugin->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
							}
						}
						break;
				}

				$query					.=	( $includeCategories ? "\n AND c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $includeCategories ) : null )
										.	( $excludeCategories ? "\n AND c." . $_CB_database->NameQuote( 'id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $excludeCategories ) : null )
										.	( $includeGroups ? "\n AND g." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $includeGroups ) : null )
										.	( $excludeGroups ? "\n AND g." . $_CB_database->NameQuote( 'id' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( $excludeGroups ) : null );

				$queries[]				=	$query;
			}

			if ( count( $queries ) > 1 ) {
				$query					=	"SELECT * FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
			} else {
				$query					=	$queries[0];
			}

			$query						.=	"\n ORDER BY " . $orderBy;
			if ( $limit ) {
				$_CB_database->setQuery( $query, 0, $limit );
			} else {
				$_CB_database->setQuery( $query );
			}
			$rows						=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

			if ( $rows ) {
				CBGroupJive::prefetchGroups( $rows );
				CBGroupJive::preFetchUsers( $rows );

				$return					=	HTML_groupjiveModule::showGroups( $rows, $user, $params, $gjPlugin );
			}
			break;
	}
}

if ( ! $return ) {
	return;
}

$class									=	$gjPlugin->params->getString( 'general_class' );

require JModuleHelper::getLayoutPath( 'mod_cbgroupjive', $params->get( 'layout', 'default' ) );