<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Conditional\Trigger;

use CB\Database\Table\TabTable;
use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Plugin\Conditional\CBConditional;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;

defined('CBLIB') or die();

class TabTrigger extends \cbPluginHandler
{

	/**
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param string    $reason
	 * @return string
	 */
	private function tabOverride( $tab, $user, $reason )
	{
		if ( ! ( $tab->getRaw( 'params' ) instanceof ParamsInterface ) ) {
			$tab->set( 'params', new Registry( $tab->getRaw( 'params', '' ) ) );
		}

		if ( ! in_array( $reason, array( 'profile', 'list' ), true ) ) {
			return null;
		}

		$override			=	CBTxt::T( $tab->params->getRaw( 'cbconditional_display_override', '' ) );
		$override			=	trim( preg_replace( '/\[cb:usertab tab="' . preg_quote( $tab->getString( 'tabid' ), '/' ) . '"[^]]+\]/i', '', $override ) );

		if ( ! $override ) {
			return null;
		}

		if ( $tab->params->getBool( 'cbconditional_display_prepare', false ) ) {
			$override		=	Application::Cms()->prepareHtmlContentPlugins( $override, 'condition.tab' );
		}

		return \CBuser::getInstance( $user->getInt( 'id', 0 ) )->replaceUserVars( $override, false, false, array( 'reason' => $reason ), false );
	}

	/**
	 * @param array     $tabsContents
	 * @param array     $tabsToDisplay
	 * @param UserTable $user
	 * @param string    $position
	 * @param int       $tabId
	 */
	public function tabsDisplay( &$tabsContents, &$tabsToDisplay, &$user, $position, $tabId )
	{
		foreach ( $tabsToDisplay as $id => $tab ) {
			if ( ! CBConditional::getTabConditional( $tab, 'profile', $user->getInt( 'id', 0 ) ) ) {
				continue;
			}

			$content			=	$this->tabOverride( $tab, $user, 'profile' );

			if ( ! $content ) {
				$content		=	null;
			}

			$tabsContents[$id]	=	$content;
		}
	}

	/**
	 * @param string    $content
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param array     $postdata
	 * @param string    $output
	 * @param string    $formatting
	 * @param string    $reason
	 * @param bool      $tabbed
	 */
	public function tabEdit( &$content, &$tab, &$user, &$postdata, $output, $formatting, $reason, $tabbed )
	{
		if ( ( ! Application::Application()->isClient( 'administrator' ) ) || CBConditional::getGlobalParams()->getBool( 'conditions_backend', false ) ) {
			if ( $output === 'htmledit' ) {
				$conditioned		=	CBConditional::getTabConditional( $tab, $reason, $user->getInt( 'id', 0 ), ( $formatting !== 'none' ) );
				$display			=	true;

				if ( $conditioned === 2 ) {
					$display		=	false;
				} elseif ( ( $formatting === 'none' ) && $conditioned ) {
					$display		=	false;
				}

				if ( ! $display ) {
					$content		=	'';
				}
			}
		}
	}

	/**
	 * @param TabTable[] $tabs
	 * @param UserTable  $user
	 * @param string     $reason
	 */
	public function tabsFetch( &$tabs, &$user, $reason )
	{
		$post				=	$this->getInput()->getNamespaceRegistry( 'post' );
		$view				=	$this->getInput()->getString( 'view' );

		if ( ! Application::Application()->isClient( 'administrator' ) ) {
			$checkView		=	( ( in_array( $reason, array( 'register', 'edit' ), true ) && $post->count() && in_array( $view, array( 'saveregisters', 'saveuseredit' ), true ) ) || ( $reason === 'profile' ) );
		} elseif ( Application::Application()->isClient( 'administrator' ) && CBConditional::getGlobalParams()->getBool( 'conditions_backend', false ) ) {
			$checkView		=	( ( in_array( $reason, array( 'register', 'edit' ), true ) && $post->count() && in_array( $view, array( 'apply', 'save' ), true ) ) || ( $reason === 'profile' ) );
		} else {
			$checkView		=	false;
		}

		if ( $checkView && $tabs && ( $user && ( $user instanceof UserTable ) && ( ! $user->getError() ) ) ) {
			foreach ( $tabs as $k => $tab ) {
				if ( CBConditional::getTabConditional( $tab, $reason, $user->getInt( 'id', 0 ) ) && ( ! $this->tabOverride( $tab, $user, $reason ) ) ) {
					unset( $tabs[$k] );
				}
			}
		}
	}
}