<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CB\Plugin\Activity\Following;
use CB\Plugin\Activity\Likes;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework, $ueConfig, $_PLUGINS;

if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
	echo 'CB not installed'; return;
}

include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

cbimport( 'cb.html' );
cbimport( 'language.front' );

$_PLUGINS->loadPluginGroup( 'user' );

if ( ! $_PLUGINS->getLoadedPlugin( 'user', 'cbactivity' ) ) {
	echo 'CB Activity not installed'; return;
}

outputCbJs();
outputCbTemplate();

$mode				=	$params->get( 'mode', 'activity' );
$templateClass		=	'cb_template cb_template_' . selectTemplate( 'dir' );
$viewer				=	CBuser::getMyUserDataInstance();
$return				=	null;

if ( $mode == 'activity' ) {
	$templateClass	=	$templateClass . ' cbActivityModuleActivity';
	$asset			=	str_replace( array( '[module_id]', '[page_id]' ), array( (int) $module->id, (int) $_CB_framework->itemid() ), $params->get( 'activity_asset' ) );

	if ( ! $asset ) {
		$asset		=	'all';
	}

	if ( ( $asset == 'notifications' ) && ( ! $viewer->get( 'id', 0, GetterInterface::INT ) ) ) {
		return;
	}

	$activity		=	new Activity( $asset, $viewer );

	$activity->parse( $params->toArray(), 'activity_' );

	$activity->set( 'module', (int) $module->id );

	if ( ( ! CBActivity::canCreate( 'activity', $activity ) ) && ( ! $activity->rows() ) ) {
		return;
	}

	if ( in_array( $params->get( 'activity_layout', 'stream' ), array( 'button', 'toggle' ) ) ) {
		$return		=	$activity->activity( 'button' );
	} else {
		$return		=	$activity->activity();
	}
} elseif ( $mode == 'notifications' ) {
	$templateClass	=	$templateClass . ' cbActivityModuleNotifications';

	$notifications	=	new Notifications( str_replace( array( '[module_id]', '[page_id]' ), array( (int) $module->id, (int) $_CB_framework->itemid() ), $params->get( 'notifications_asset' ) ), $viewer );

	$notifications->parse( $params->toArray(), 'notifications_' );

	$notifications->set( 'module', (int) $module->id );

	$layout			=	$params->get( 'notifications_layout', 'button' );

	switch ( $params->get( 'notifications_state', 'unread' ) ) {
		case 'read':
			if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
				$notifications->set( 'read', 'read' );
			} else {
				$notifications->set( 'read', 'readonly' );
			}
			break;
		case 'unread':
			if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
				$notifications->set( 'read', 'unread' );
			} else {
				$notifications->set( 'read', 'unreadonly' );
			}
			break;
		case 'all':
			$notifications->set( 'read', 'status' );
			break;
	}

	if ( in_array( $layout, array( 'button', 'toggle' ) ) ) {
		$return		=	$notifications->notifications( 'button' );
	} else {
		if ( ! $notifications->rows() ) {
			return;
		}

		$return		=	$notifications->notifications();
	}
} elseif ( $mode == 'comments' ) {
	$templateClass	=	$templateClass . ' cbActivityModuleComments';
	$asset			=	str_replace( array( '[module_id]', '[page_id]' ), array( (int) $module->id, (int) $_CB_framework->itemid() ), $params->get( 'comments_asset' ) );

	if ( ! $asset ) {
		$asset		=	'module.' . (int) $module->id;
	}

	$comments		=	new Comments( $asset, $viewer );

	$comments->parse( $params->toArray(), 'comments_' );

	$comments->set( 'module', (int) $module->id );

	if ( ( ! CBActivity::canCreate( 'comment', $comments ) ) && ( ! $comments->rows() ) ) {
		return;
	}

	if ( in_array( $params->get( 'comments_layout', 'stream' ), array( 'button', 'toggle' ) ) ) {
		$return		=	$comments->comments( 'button' );
	} else {
		$return		=	$comments->comments();
	}
} elseif ( $mode == 'follow' ) {
	$templateClass	=	$templateClass . ' cbActivityModuleFollow';
	$asset			=	str_replace( array( '[module_id]', '[page_id]' ), array( (int) $module->id, (int) $_CB_framework->itemid() ), $params->get( 'following_asset' ) );

	if ( ! $asset ) {
		$asset		=	'page.' . (int) $_CB_framework->itemid();
	}

	$following		=	new Following( $asset, $viewer );

	$following->parse( $params->toArray(), 'following_' );

	$following->set( 'module', (int) $module->id );

	if ( ( ! CBActivity::canCreate( 'follow', $following ) ) && ( ! $following->rows() ) ) {
		return;
	}

	if ( $params->get( 'following_layout', 'button' ) == 'stream' ) {
		$return		=	$following->following();
	} else {
		$return		=	$following->following( 'button' );
	}
} elseif ( $mode == 'like' ) {
	$templateClass	=	$templateClass . ' cbActivityModuleLike';
	$asset			=	str_replace( array( '[module_id]', '[page_id]' ), array( (int) $module->id, (int) $_CB_framework->itemid() ), $params->get( 'likes_asset' ) );

	if ( ! $asset ) {
		$asset		=	'page.' . (int) $_CB_framework->itemid();
	}

	$likes			=	new Likes( $asset, $viewer );

	$likes->parse( $params->toArray(), 'likes_' );

	$likes->set( 'module', (int) $module->id );

	if ( ( ! CBActivity::canCreate( 'like', $likes ) ) && ( ! $likes->rows() ) ) {
		return;
	}

	if ( $params->get( 'likes_layout', 'button' ) == 'stream' ) {
		$return		=	$likes->likes();
	} else {
		$return		=	$likes->likes( 'button' );
	}
}

if ( ! $return ) {
	return;
}

require JModuleHelper::getLayoutPath( 'mod_cbactivity', $params->get( 'layout', 'default' ) );