<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\ReconfirmEmail;

use CBLib\Registry\Registry;

defined( 'CBLIB') or die();

class Helper
{
	/**
	 * @var array The array of users who have changed their email
	 */
	static private $changed		=	array();
	/**
	 * @var array The array of users who are changing their email
	 */
	static private $changing	=	array();

	/**
	 * @return Registry
	 */
	static public function getGlobalParams()
	{
		global $_PLUGINS;

		static $params	=	null;

		if ( ! $params ) {
			$plugin		=	$_PLUGINS->getLoadedPlugin( 'user', 'cbreconfirmemail' );
			$params		=	new Registry();

			if ( $plugin ) {
				$params->load( $plugin->params );
			}
		}

		return $params;
	}

	/**
	 * Checks if user email address was changed
	 *
	 * @param int $userId
	 * @return bool
	 */
	static public function getEmailChanged( $userId )
	{
		if ( isset( self::$changed[$userId] ) ) {
			return true;
		}

		return false;
	}

	/**
	 * Sets if the user email address was changed and to what
	 *
	 * @param int    $userId
	 * @param string $newEmail
	 * @param string $oldEmail
	 */
	static public function setEmailChanged( $userId, $newEmail, $oldEmail = null )
	{
		if ( ( $newEmail === null ) && self::getEmailChanged( $userId ) ) {
			unset( self::$changed[$userId] );

			return;
		}

		self::$changed[$userId]	=	array( 'new' => $newEmail, 'old' => $oldEmail );
	}

	/**
	 * Checks if user email address is currently changing
	 *
	 * @param int $userId
	 * @return bool
	 */
	static public function getEmailChanging( $userId )
	{
		if ( isset( self::$changing[$userId] ) ) {
			return true;
		}

		return false;
	}

	/**
	 * Sets if the user email address is currently changing
	 *
	 * @param int    $userId
	 * @param string $newEmail
	 * @param string $oldEmail
	 */
	static public function setEmailChanging( $userId, $newEmail, $oldEmail = null )
	{
		if ( ( $newEmail === null ) && self::getEmailChanging( $userId ) ) {
			unset( self::$changing[$userId] );

			return;
		}

		self::$changing[$userId]	=	array( 'new' => $newEmail, 'old' => $oldEmail );
	}

	/**
	 * Returns the old email address that is being changed
	 *
	 * @param int $userId
	 * @return string
	 */
	static public function getOldEmail( $userId )
	{
		if ( isset( self::$changing[$userId] ) ) {
			return self::$changing[$userId]['old'];
		}

		if ( isset( self::$changed[$userId] ) ) {
			return self::$changed[$userId]['old'];
		}

		return null;
	}

	/**
	 * Returns the new email address being changed to
	 *
	 * @param int $userId
	 * @return string
	 */
	static public function getNewEmail( $userId )
	{
		if ( isset( self::$changing[$userId] ) ) {
			return self::$changing[$userId]['new'];
		}

		if ( isset( self::$changed[$userId] ) ) {
			return self::$changed[$userId]['new'];
		}

		return null;
	}
}