<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2015 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\TabTable;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\ReconfirmEmail\Helper;
use CB\Plugin\ReconfirmEmail\Table\ReconfirmEmailTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbreconfirmemail extends cbPluginHandler
{
	/**
	 * @param TabTable   $tab
	 * @param UserTable  $user
	 * @param int        $ui
	 * @param array      $postdata
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		global $_PLUGINS;

		$action						=	$this->input( 'action', null, GetterInterface::STRING );
		$confirmcode				=	$this->input( 'confirmcode', null, GetterInterface::STRING );

		if ( ! $confirmcode ) {
			cbRedirect( 'index.php', CBTxt::T( 'Confirm code missing.' ), 'error' );
		}

		$row						=	new ReconfirmEmailTable();

		$row->load( array( 'code' => $confirmcode ) );

		if ( ! $row->get( 'id', 0, GetterInterface::INT ) ) {
			cbRedirect( 'index.php', CBTxt::T( 'Confirm code missing.' ), 'error' );
		}

		$userId						=	$row->get( 'user_id', 0, GetterInterface::INT );

		if ( ! $userId ) {
			cbRedirect( 'index.php', CBTxt::T( 'User not associated with confirm code.' ), 'error' );
		}

		if ( $row->expired() ) {
			cbRedirect( 'index.php', CBTxt::T( 'Email address change request has expired.' ), 'error' );
		}

		$cbUser						=	CBuser::getInstance( (int) $userId, false );
		$user						=	$cbUser->getUserData();

		if ( $row->get( 'status', null, GetterInterface::STRING ) == 'X' ) {
			cbRedirect( 'index.php', CBTxt::T( 'Email address change request has already been cancelled.' ), 'notice' );
		} elseif ( $row->get( 'status', null, GetterInterface::STRING ) != 'P' ) {
			cbRedirect( 'index.php', CBTxt::T( 'Email address has already been confirmed' ), 'notice' );
		}

		if ( $action == 'cancel' ) {
			$_PLUGINS->trigger( 'reconfirm_onBeforeCancel', array( &$user, &$row, $confirmcode ) );

			if ( ! $row->cancel() ) {
				cbRedirect( 'index.php', CBTxt::T( 'FAILED_CANCEL_RECONFIRM_EMAIL', 'Failed to cancel new email address! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
			}

			$_PLUGINS->trigger( 'reconfirm_onAfterCancel', array( $user, $row, $confirmcode ) );

			$redirect				=	$cbUser->replaceUserVars( $this->params->get( 'reconfirm_cancel_redirect', null, GetterInterface::STRING ), false, false, null, false );
			$message				=	$cbUser->replaceUserVars( CBTxt::T( $this->params->get( 'reconfirm_cancel_message', 'Email address change cancelled successfully!', GetterInterface::HTML ) ), true, false, null, false );

			if ( $redirect ) {
				cbRedirect( cbSef( $redirect, false ), $message );
			} else {
				echo '<div class="cbReconfirmEmail cbReconfirmEmailCancelled">' . $message . '</div>';
			}
		} else {
			Helper::setEmailChanged( $row->get( 'user_id', 0, GetterInterface::INT ), $row->get( 'to', null, GetterInterface::STRING ), $user->get( 'email', null, GetterInterface::STRING ) );

			$_PLUGINS->trigger( 'reconfirm_onBeforeConfirm', array( &$user, &$row, $confirmcode ) );

			if ( ! $row->confirm() ) {
				cbRedirect( 'index.php', CBTxt::T( 'FAILED_RECONFIRM_EMAIL', 'Failed to confirm new email address! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
			}

			$_PLUGINS->trigger( 'reconfirm_onAfterConfirm', array( $user, $row, $confirmcode ) );

			$redirect				=	$cbUser->replaceUserVars( $this->params->get( 'reconfirm_redirect', 'index.php', GetterInterface::STRING ), false, false, null, false );
			$message				=	$cbUser->replaceUserVars( CBTxt::T( $this->params->get( 'reconfirm_message', 'New email address confirmed successfully!', GetterInterface::HTML ) ), true, false, null, false );

			if ( $redirect ) {
				cbRedirect( cbSef( $redirect, false ), $message );
			} else {
				echo '<div class="cbReconfirmEmail cbReconfirmEmailConfirmed">' . $message . '</div>';
			}
		}
	}
}