<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2015 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Privacy\Table\ClosedTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var int         $userId
 * @var UserTable   $user
 * @var ClosedTable $closed
 */

global $_CB_framework;

cbValidator::loadValidation();
initToolTip();

if ( $userId != $user->get( 'id', 0, GetterInterface::INT ) ) {
	$pageTitle		=	CBTxt::T( 'USER_ACCOUNT_PENDING_DISABLE', '[user] Account Pending Disable', array( '[user]' => CBuser::getInstance( $userId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
} else {
	$pageTitle		=	CBTxt::T( 'Account Pending Disable' );
}

if ( $pageTitle ) {
	$_CB_framework->setPageTitle( $pageTitle );
}
?>
<div class="privacyPendingDisableAccount">
	<?php if ( $pageTitle ) { ?>
		<div class="mb-3 border-bottom cb-page-header privacyTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $pageTitle; ?></h3></div>
	<?php } ?>
	<div class="form-group row no-gutters sectiontableentry2 cbft_textarea cb_form_line">
		<label class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Reason' ); ?></label>
		<div class="cb_field col-sm-9">
			<div class="form-control-plaintext">
				<?php echo htmlspecialchars( $closed->getString( 'reason', '' ) ); ?>
			</div>
		</div>
	</div>
	<div class="form-group row no-gutters sectiontableentry1 cbft_datetime cb_form_line">
		<label class="col-form-label col-sm-3 pr-sm-2"><?php echo CBTxt::T( 'Date' ); ?></label>
		<div class="cb_field col-sm-9">
			<div class="form-control-plaintext">
				<?php echo cbFormatDate( $closed->getString( 'date', '' ) ); ?>
			</div>
		</div>
	</div>
	<div class="row no-gutters">
		<div class="offset-sm-3 col-sm-9">
			<input type="button" value="<?php echo htmlspecialchars( CBTxt::T( 'Cancel Account Disable' ) ); ?>" class="privacyButton privacyButtonCancel btn btn-secondary" onclick="window.location.href = '<?php echo addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'disable', 'func' => 'cancel', 'id' => $userId ) ) ); ?>';" />
		</div>
	</div>
</div>