<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Privacy\CBPrivacy;
use CB\Plugin\Privacy\Privacy;
use CBLib\Input\Get;
use CBLib\Registry\GetterInterface;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Privacy/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\Privacy\Trigger\AdminTrigger' );

$_PLUGINS->registerFunction( 'onPrepareMenus', 'getBlock','\CB\Plugin\Privacy\Trigger\MenuTrigger' );

$_PLUGINS->registerFunction( 'onBeforeUserProfileAccess', 'getProfile', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onBeforeEmailUserForm', 'getEmailForm', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'pm_onBeforeDisplayMessageEdit', 'getPMForm', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'pm_onBeforeCreateMessage', 'sendPM', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'pm_onDisplayMessage', 'readPM', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'pm_onBeforeDisplayMessage', 'readPM', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onBeforeAddConnectionRequest', 'requestConnection', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deletePrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onDuringLogin', 'checkDisabled', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterNewUser', 'saveRegistrationPrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterUserRegistration', 'saveRegistrationPrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterUpdateUser', 'saveEditPrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterUserUpdate', 'saveEditPrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'fieldgroups_onAfterPrepareFieldDataSave', 'saveFieldGroupPrivacy', '\CB\Plugin\Privacy\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onVerifyConsent', 'verifyConsent', '\CB\Plugin\Privacy\Trigger\UserTrigger' );

$_PLUGINS->registerFunction( 'onAfterPrepareViewTabs', 'tabsDisplay', '\CB\Plugin\Privacy\Trigger\TabTrigger' );
$_PLUGINS->registerFunction( 'onAfterEditATab', 'tabEdit', '\CB\Plugin\Privacy\Trigger\TabTrigger' );
$_PLUGINS->registerFunction( 'onAfterTabsFetch', 'tabsFetch', '\CB\Plugin\Privacy\Trigger\TabTrigger' );

$_PLUGINS->registerFunction( 'fieldgroups_onAfterFieldsFetch', 'fieldGroupsFieldsFetch', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onAfterFieldsFetch', 'fieldsFetch', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforeprepareFieldDataSave', 'fieldPrepareSave', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onFieldIcons', 'fieldIcons', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforegetFieldRow', 'beforeFieldDisplay', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onAftergetFieldRow', 'afterFieldDisplay', '\CB\Plugin\Privacy\Trigger\FieldTrigger' );

$_PLUGINS->registerFunction( 'onBeforeDisplayUsersList', 'getList', '\CB\Plugin\Privacy\Trigger\UserlistTrigger' );
$_PLUGINS->registerFunction( 'search_onBeforeResults', 'getSearch', '\CB\Plugin\Privacy\Trigger\UserlistTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array(	'privacy'				=>	'\CB\Plugin\Privacy\Field\PrivacyField',
											'privacy_profile'		=>	'\CB\Plugin\Privacy\Field\PrivacyField',
											'privacy_disable_me'	=>	'\CB\Plugin\Privacy\Field\DisableField',
											'privacy_delete_me'		=>	'\CB\Plugin\Privacy\Field\DeleteField',
											'privacy_export'		=>	'\CB\Plugin\Privacy\Field\ExportField'
										));

class cbprivacyTab extends cbTabHandler
{

	/**
	 * Generates the HTML to display the user edit tab
	 *
	 * @param  TabTable   $tab       the tab database entry
	 * @param  UserTable  $user      the user being displayed
	 * @param  int        $ui        1 for front-end, 2 for back-end
	 * @return string|boolean|array  Either string HTML for tab content, false if ErrorMSG generated, array if an array of fields to output
	 */
	public function getEditTab( $tab, $user, $ui )
	{
		$privacyControls	=	$this->getSimpleControls( $tab, $user, 'edit' );

		if ( ! $privacyControls ) {
			return null;
		}

		$tabDescription		=	cbReplaceVars( $tab->get( 'description', null, GetterInterface::HTML ), $user, true, true, array( 'reason' => 'edit' ) );

		if ( $tabDescription ) {
			$descField		=	new FieldTable();

			$descField->set( 'name', 'privacy_simple_desc' );
			$descField->set( 'value', $tabDescription );
			$descField->set( 'table', '#__comprofiler' );
			$descField->set( 'type', 'delimiter' );
			$descField->set( 'ordering', 1 );
			$descField->set( 'published', 1 );
			$descField->set( 'registration', 4 );
			$descField->set( 'edit', 4 );
			$descField->set( 'profile', 0 );
			$descField->set( 'readonly', 0 );
			$descField->set( 'searchable', 0 );
			$descField->set( 'calculated', 1 );
			$descField->set( 'sys', 1 );
			$descField->set( 'pluginid', $this->getPluginId() );
			$descField->set( 'cssclass', 'cbPrivacySimpleDescription' );
			$descField->set( 'params', new Registry() );

			array_unshift( $privacyControls, $descField );
		}

		return $privacyControls;
	}

	/**
	 * Generates the HTML to display the registration tab/area
	 *
	 * @param  TabTable   $tab       the tab database entry
	 * @param  UserTable  $user      the user being displayed
	 * @param  int        $ui        1 for front-end, 2 for back-end
	 * @param  array      $postdata  _POST data for saving edited tab content as generated with getEditTab
	 * @return string|boolean|array  Either string HTML for tab content, false if ErrorMSG generated, array if an array of fields to output
	 */
	public function getDisplayRegistration( $tab, $user, $ui, $postdata )
	{
		$privacyControls	=	$this->getSimpleControls( $tab, $user, 'register' );

		if ( ! $privacyControls ) {
			return null;
		}

		return $privacyControls;
	}

	/**
	 * Outputs simple privacy controls field array
	 *
	 * @param TabTable  $tab
	 * @param userTable $user
	 * @param string    $reason
	 * @return array|null
	 */
	private function getSimpleControls( $tab, $user, $reason )
	{
		$privacyControls					=	CBPrivacy::getGroupedPrivacy();

		if ( ! $privacyControls ) {
			return array();
		}

		$groups								=	array();

		foreach ( $privacyControls as $group => $groupPrivacy ) {
			if ( $group && $groupPrivacy ) {
				$groupField					=	$this->getGroupField( $group, $user, $reason );

				if ( $groupField ) {
					$groups[$group][]		=	$groupField;
				}
			}

			foreach ( $groupPrivacy as $tabId => $tabPrivacy ) {
				// Check if the tab it self has privacy controls:
				if ( isset( $tabPrivacy['tab'] ) && isset( $tabPrivacy['privacy'] ) ) {
					$privacyField			=	$this->getPrivacyField( $tabPrivacy['tab'], $tabPrivacy['privacy'], $user, $reason );

					if ( $privacyField ) {
						$groups[$group][]	=	$privacyField;
					}
				}

				// Check if the tab has fields with privacy controls:
				if ( isset( $tabPrivacy['fields'] ) ) {
					foreach ( $tabPrivacy['fields'] as $fieldPrivacy ) {
						if ( ( ! isset( $fieldPrivacy['field'] ) ) || ( ! isset( $fieldPrivacy['privacy'] ) ) ) {
							continue;
						}

						$privacyField		=	$this->getPrivacyField( $fieldPrivacy['field'], $fieldPrivacy['privacy'], $user, $reason );

						if ( ! $privacyField ) {
							continue;
						}

						$groups[$group][]	=	$privacyField;
					}
				}
			}
		}

		$fields								=	array();

		foreach ( $groups as $group => $privacy ) {
			if ( ! $group ) {
				$fields						=	array_merge( $privacy, $fields );
			} else {
				$fields						=	array_merge( $fields, $privacy );
			}
		}

		return $fields;
	}

	/**
	 * Prepares a pseudo privacy field
	 *
	 * @param TabTable|FieldTable $object
	 * @param Privacy             $privacy
	 * @param UserTable           $user
	 * @param string              $reason
	 * @return FieldTable|null
	 */
	private function getPrivacyField( $object, $privacy, $user, $reason ) {
		if ( ( ! $privacy ) || ( ! $privacy->rules() ) || ( $privacy->getString( 'layout', 'button' ) == 'hidden' ) ) {
			return null;
		}

		if ( ! $object->get( '_params', null, GetterInterface::RAW ) instanceof Registry ) {
			$object->set( '_params', new Registry( $object->get( 'params', null, GetterInterface::RAW ) ) );
		}

		$privacyField	=	new FieldTable();

		$name			=	'privacy_simple';
		$cssClass		=	'cbPrivacySimpleControl';
		$langKey		=	null;

		if ( $object instanceof FieldTable ) {
			$name		=	'_field_' . $object->get( 'fieldid', 0, GetterInterface::INT );
			$cssClass	.=	' cbPrivacySimpleControlField' . $object->get( 'fieldid', 0, GetterInterface::INT );
		} elseif ( $object instanceof TabTable ) {
			$name		=	'_tab_' . $object->get( 'tabid', 0, GetterInterface::INT );
			$cssClass	.=	' cbPrivacySimpleControlTab' . $object->get( 'tabid', 0, GetterInterface::INT );
		}

		$title			=	$object->params->get( 'cbprivacy_simple_title', null, GetterInterface::HTML );

		if ( ! $title ) {
			$title		=	$object->get( 'title', null, GetterInterface::HTML );
		}

		$privacyField->set( 'name', $name );
		$privacyField->set( 'table', '#__comprofiler' );
		$privacyField->set( 'title', $title );
		$privacyField->set( 'description', $object->params->get( 'cbprivacy_simple_description', null, GetterInterface::HTML ) );
		$privacyField->set( 'type', 'privacy' );
		$privacyField->set( 'ordering', 999 );
		$privacyField->set( 'published', 1 );
		$privacyField->set( 'registration', 1 );
		$privacyField->set( 'edit', 1 );
		$privacyField->set( 'profile', 0 );
		$privacyField->set( 'readonly', 0 );
		$privacyField->set( 'searchable', 0 );
		$privacyField->set( 'calculated', 1 );
		$privacyField->set( 'sys', 1 );
		$privacyField->set( 'pluginid', $this->getPluginId() );
		$privacyField->set( 'cssclass', $cssClass );
		$privacyField->set( 'params', new Registry( array( 'fieldLayoutIcons' => $object->params->get( 'cbprivacy_simple_description_icon', 4, GetterInterface::INT ) ) ) );

		$privacy->set( 'class', null ); // Ignore per-privacy control CSS classes for simplified output

		$privacyField->set( '_privacy', $privacy );

		return $privacyField;
	}

	/**
	 * Prepares a pseudo delimiter field for privacy controls group
	 *
	 * @param string    $group
	 * @param UserTable $user
	 * @param string    $reason
	 * @return FieldTable|null
	 */
	private function getGroupField( $group, $user, $reason )
	{
		if ( ! $group ) {
			return null;
		}

		$name			=	preg_replace( '/[^a-zA-Z0-9_]+/', '', strtolower( Get::clean( $group, GetterInterface::STRING ) ) );

		$groupField		=	new FieldTable();

		$groupField->set( 'name', 'privacy_simple_group_' . $name );
		$groupField->set( 'value', cbReplaceVars( $group, $user, true, true, array( 'reason' => $reason ) ) );
		$groupField->set( 'table', '#__comprofiler' );
		$groupField->set( 'type', 'delimiter' );
		$groupField->set( 'ordering', 1 );
		$groupField->set( 'published', 1 );
		$groupField->set( 'registration', 4 );
		$groupField->set( 'edit', 4 );
		$groupField->set( 'profile', 0 );
		$groupField->set( 'readonly', 0 );
		$groupField->set( 'searchable', 0 );
		$groupField->set( 'calculated', 1 );
		$groupField->set( 'sys', 1 );
		$groupField->set( 'pluginid', $this->getPluginId() );
		$groupField->set( 'cssclass', 'cbPrivacySimpleGroup cbPrivacySimpleGroup' . ucfirst( $name ) );
		$groupField->set( 'params', new Registry() );

		return $groupField;
	}
}