<?php
/**
 * @version			2.2.0
 * @author			Nicholas G. Antimisiaris
 * @authoremail		nant@joomlapolis.com
 * @authorurl		www.joomlapolis.com
 * @package			Joomla 2 CiviCRM User Sync
 * @file			durationdatetimelist.php
 * @copyright		Copyright (C) 2013-2019. All rights reserved
 * @license			GNU GPL version 2
 * @description		Code used by Joomla plugin parameter form to present strtotime related input
 * 					that can be used to schedule a date based on current one.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

class JFormFielddurationdatetimelist extends JFormFieldList
{
	protected $type = 'durationdatetimelist';

	/**
 	* Method to get the field options.
 	*
 	* @return  array  The field option objects.
 	*
 	* @since   11.1
 	*/
	protected function getOptions()
	{
		// Initialize variables.
		$options = array();

		// TODO - need to figure out how to load language file for this
		//$lang = JFactory::getLanguage();
		//$lang->load('plg_user_joomla2civicrmusersync', JPATH_ADMINISTRATOR);

		$_durationlist = array(
			'MIDNIGHT'					=> 'DUR_MIDNIGHT',
			'NOON'						=> 'DUR_NOON',
			'TOMORROW'					=> 'DUR_TOMORROW',
			'NEXT MONDAY'				=> 'DUR_NEXT_MONDAY',
			'NEXT TUESDAY'				=> 'DUR_NEXT_TUESDAY',
			'NEXT WEDNESDAY'			=> 'DUR_NEXT_WEDNESDAY',
			'NEXT THURSDAY'				=> 'DUR_NEXT_THURSDAY',
			'NEXT FRIDAY'				=> 'DUR_NEXT_FRIDAY',
			'NEXT SATURDAY'				=> 'DUR_NEXT_SATURDAY',
			'NEXT SUNDAY'				=> 'DUR_NEXT_SUNDAY',
			'NEXT WEEK'					=> 'DUR_NEXT_WEEK',
			'NEXT MONTH'				=> 'DUR_NEXT_MONTH',
			'NEXT YEAR'					=> 'DUR_NEXT_YEAR',
			'LAST DAY OF THIS MONTH'	=> 'DUR_LAST_DAY_OF_THIS_MONTH',
			'FIRST DAY OF NEXT MONTH'	=> 'DUR_FIRST_DAY_OF_NEXT_MONTH',
			'LAST DAY OF NEXT MONTH'	=> 'DUR_LAST_DAY_OF_NEXT_MONTH',
			'LAST DAY OF THIS YEAR'		=> 'DUR_LAST_DAY_OF_THIS_YEAR',
			'FIRST DAY OF NEXT YEAR'	=> 'DUR_FIRST_DAY_OF_NEXT_YEAR',
			'LAST DAY OF NEXT YEAR'		=> 'DUR_LAST_DAY_OF_NEXT_YEAR',
			'FIRST DAY OF JANUARY'		=> 'DUR_FIRST_DAY_OF_JANUARY',
			'LAST DAY OF JANUARY'		=> 'DUR_LAST_DAY_OF_JANUARY',
			'FIRST DAY OF FEBRUARY'		=> 'DUR_FIRST_DAY_OF_FEBRUARY',
			'LAST DAY OF FEBRUARY'		=> 'DUR_LAST_DAY_OF_FEBRUARY',
			'FIRST DAY OF MARCH'		=> 'DUR_FIRST_DAY_OF_MARCH',
			'LAST DAY OF MARCH'			=> 'DUR_LAST_DAY_OF_MARCH',
			'FIRST DAY OF APRIL'		=> 'DUR_FIRST_DAY_OF_APRIL',
			'LAST DAY OF APRIL'			=> 'DUR_LAST_DAY_OF_APRIL',
			'FIRST DAY OF MAY'			=> 'DUR_FIRST_DAY_OF_MAY',
			'LAST DAY OF MAY'			=> 'DUR_LAST_DAY_OF_MAY',
			'FIRST DAY OF JUNE'			=> 'DUR_FIRST_DAY_OF_JUNE',
			'LAST DAY OF JUNE'			=> 'DUR_LAST_DAY_OF_JUNE',
			'FIRST DAY OF JULY'			=> 'DUR_FIRST_DAY_OF_JULY',
			'LAST DAY OF JULY'			=> 'DUR_LAST_DAY_OF_JULY',
			'FIRST DAY OF AUGUST'		=> 'DUR_FIRST_DAY_OF_AUGUST',
			'LAST DAY OF AUGUST'		=> 'DUR_LAST_DAY_OF_AUGUST',
			'FIRST DAY OF SEPTEMBER'	=> 'DUR_FIRST_DAY_OF_SEPTEMBER',
			'LAST DAY OF SEPTEMBER'		=> 'DUR_LAST_DAY_OF_SEPTEMBER',
			'FIRST DAY OF OCTOBER'		=> 'DUR_FIRST_DAY_OF_OCTOBER',
			'LAST DAY OF OCTOBER'		=> 'DUR_LAST_DAY_OF_OCTOBER',
			'FIRST DAY OF NOVEMBER'		=> 'DUR_FIRST_DAY_OF_NOVEMBER',
			'LAST DAY OF NOVEMBER'		=> 'DUR_LAST_DAY_OF_NOVEMBER',
			'FIRST DAY OF DECEMBER'		=> 'DUR_FIRST_DAY_OF_DECEMBER',
			'LAST DAY OF DECEMBER'		=> 'DUR_LAST_DAY_OF_DECEMBER',
			'+30 MINUTES'				=> 'DUR_+30_MINUTES',
			'+1 HOUR'					=> 'DUR_+1_HOUR',
			'+3 HOURS'					=> 'DUR_+3_HOURS',
			'+6 HOURS'					=> 'DUR_+6_HOURS',
			'+12 HOURS'					=> 'DUR_+12_HOURS',
			'+1 DAY'					=> 'DUR_+1_DAY',
			'+3 DAYS'					=> 'DUR_+3_DAYS',
			'+6 DAYS'					=> 'DUR_+6_DAYS',
			'+12 DAYS'					=> 'DUR_+12_DAYS',
			'+1 WEEK'					=> 'DUR_+1_WEEK',
			'+2 WEEKS'					=> 'DUR_+2_WEEKS',
			'+3 WEEKS'					=> 'DUR_+3_WEEKS',
			'+1 MONTH'					=> 'DUR_+1_MONTH',
			'+3 MONTHS'					=> 'DUR_+3_MONTHS',
			'+6 MONTHS'					=> 'DUR_+6_MONTHS',
			'+1 YEAR'					=> 'DUR_+1_YEAR'
		);

		foreach ($_durationlist as $_key => $_value) {

			$_dur_tmp = JHtml::_(
				'select.option', (string) $_key,
				JText::alt(trim((string) $_value), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)),
				'value', 'text',
				((string) false)
			);

			$_dur_tmp->class = (string) '';
			$_dur_tmp->onclick = (string) '';

			$options[] = $_dur_tmp;

		}

		reset($options);

		return $options;
	}
}


