<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$editor = Editor::getInstance(Factory::getConfig()->get('editor'));

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('formbehavior.chosen', 'select');
}

HTMLHelper::_('behavior.core');
HTMLHelper::_('behavior.keepalive');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('behavior.modal', 'a.hdp-modal');
}

$rootUri = Uri::root(true);
$document = Factory::getDocument();

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/jquery.selection.js');
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js');
}

OSSolution\HelpdeskPro\Site\Helper\Jquery::validateForm();

$document->addScript($rootUri.'/media/com_helpdeskpro/js/admin-ticket-form.js');
?>
<div class="container-fluid">
	<form class="form form-horizontal" name="adminForm" id="adminForm" action="index.php" method="post"
	      enctype="multipart/form-data">
		<div class="control-group">
			<label class="control-label" for="name"><?php echo Text::_('HDP_NAME'); ?><span
					class="required">*</span></label>
			<div class="controls">
				<input type="text" id="name" name="name" placeholder="<?php echo Text::_('HDP_CUSTOMER_NAME'); ?>" class="input-large form-control validate[required]"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="email"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></label>
			<div class="controls">
				<input type="text" id="email" name="email" placeholder="<?php echo Text::_('HDP_CUSTOMER_EMAIL'); ?>" class="input-large form-control validate[required,custom[email]]"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="category_id"><?php echo Text::_('HDP_CATEGORY'); ?><span
					class="required">*</span></label>
			<div class="controls">
				<?php echo $this->lists['category_id']; ?>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="subject"><?php echo Text::_('HDP_SUBJECT'); ?><span
					class="required">*</span></label>
			<div class="controls">
				<input type="text" id="subject" name="subject" class="input-xxlarge form-control validate[required]" value="" size="50"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" for="priority_id"><?php echo Text::_('HDP_PRIORITY'); ?><span
					class="required">*</span></label>
			<div class="controls">
				<?php echo $this->lists['priority_id']; ?>
			</div>
		</div>
		<?php
		$fields = $this->form->getFields();

		/* @var HDPFormField $field*/
		foreach ($fields as $field)
		{
			echo $field->getControlGroup();
		}
		?>
		<div class="control-group">
			<label class="control-label" for="message"><?php echo Text::_('HDP_MESSAGE'); ?><span
					class="required">*</span></label>
			<div class="controls">
				<?php
				if ($this->config->use_html_editor)
				{
					echo $editor->display('message', '', '100%', '250', '75', '10');
				}
				else
				{
				?>
					<textarea rows="10" cols="70" class="hdp_fullwidth" name="message" class="form-control validate[required]"></textarea>
				<?php
				}
				?>
			</div>
		</div>
		<?php
		if ($this->config->enable_attachment)
		{
		?>
			<div class="control-group">
				<label class="control-label"><?php echo Text::_('HDP_ATTACHMENTS'); ?></label>
				<div class="controls">
                    <div id="hdp_ticket_attachments" class="dropzone needsclick dz-clickable">

                    </div>
				</div>
			</div>
		<?php
			echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
		}
		?>
		<div class="form-actions">
			<input type="button" name="btnSubmit" class="btn btn-primary" value="<?php echo Text::_('HDP_CANCEL'); ?>"
			       onclick="HDP.ticketList();"/>
			<input type="submit" name="btnSubmit" class="btn btn-primary"
			       value="<?php echo Text::_('HDP_SUBMIT_TICKET'); ?>" />
		</div>
		<input type="hidden" name="option" value="com_helpdeskpro"/>
		<input type="hidden" name="task" value="ticket.save"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>