<?php // no direct access

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$user = JFactory::getUser();

// MULTI LANGUAGE
if($this->payment->language){
	$lang = JFactory::getLanguage();
	$lang->load('joomla', JPATH_SITE, $this->payment->language, true);
	$lang->load('com_invoices', JPATH_SITE, $this->payment->language, true);
}

$payment_status = InvoicesHelper::getPaymentStatus();

switch($this->payment->towho){
	case "user":
	
		$theusername = $this->payment->theusername ;
		
	break;	
	case "admin":
	
		$theusername = JText::_('ADMINISTRATOR') ;
		
	
	break;
}

switch($this->payment->payment_status){
	case 1:
	
		$themessage = JText::_( 'EMAIL_PAYMENT_SUCCESSFULL' );
	
	break;
	case 2:
	
		$themessage = JText::_( 'EMAIL_PAYMENT_PENDING' );
	
	break;
	case 0:
	
		$themessage = JText::_( 'EMAIL_PAYMENT_UNSUCCESSFULL' );
	
	break;	
	
}

?>

<?php echo JText::sprintf( 'EMAIL_PAYMENT_SALUTATION', $theusername ); ?><br /><br />

<?php echo $themessage; ?><br /><br />

<strong><?php echo JText::_( 'USER_DETAILS' ); ?></strong>:<br /><br />

<?php echo JText::_( 'USERNAME' ); ?>: <?php echo $this->payment->username; ?><br />
<?php echo JText::_( 'EMAIL' ); ?>: <?php echo $this->payment->to_email; ?><br />

<br />
<strong><?php echo JText::_( 'PAYMENT_DETAILS' ); ?></strong>:<br /><br />


<?php echo JText::_( 'PAYMENT_AMOUNT' ); ?>: <?php echo InvoicesHelper::format($this->payment->payment_amount, $this->payment->currency_before, $this->payment->currency_after); ?><br />
<?php echo JText::_( 'PAYMENT_CREATION' ); ?>: <?php if($this->payment->created_datetime == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->created_datetime, JText::_('DATE_FORMAT_LC3'), false); ?><br />
<?php echo JText::_( 'PAYMENT_DUEDATE' ); ?>: <?php if($this->payment->payment_duedate == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->payment_duedate, JText::_('DATE_FORMAT_LC3'), false); ?><br />
<?php echo JText::_( 'PAYMENT_DATETIME' ); ?>: <?php if($this->payment->payment_datetime == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->payment_datetime, JText::_('DATE_FORMAT_LC3'), false); ?><br />
<?php echo JText::_( 'PAYMENT_DESCRIPTION' ); ?>: <?php echo $this->payment->payment_description; ?><br />
<?php echo JText::_( 'PAYMENT_METHOD' ); ?>: <?php echo JText::_($this->payment->payment_type); ?><br />
<?php echo JText::_( 'PAID' ); ?>: <?php echo $this->payment->payment_status ? JText::_('JYES') : JText::_('JNO'); ?><br />
<?php echo JText::_( 'STATUS' ); ?>: <?php echo $payment_status[$this->payment->payment_status]; ?><br />

<br />
<strong><?php echo JText::_( 'INVOICE_DETAILS' ); ?></strong>:<br /><br />

<?php echo JText::_( 'INVOICE_NUM' ); ?>: <?php echo JText::_($this->payment->invoice_num); ?><br />
<?php echo JText::_( 'INVOICE_DATE' ); ?>: <?php if($this->payment->invoice_date == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->invoice_date, JText::_('DATE_FORMAT_LC3'), false); ?><br />

<br />
<div align="center"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>