<?php // no direct access

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$user = JFactory::getUser();

$payment_status = InvoicesHelper::getPaymentStatus();

if($this->payment->payment_status){
	$thestatus = 1;
	$class = " payment_paid";
	$label_class = "success";
}
elseif($this->payment->payment_duedate != "0000-00-00 00:00:00" && !$this->payment->payment_status){
	if(strtotime($this->payment->payment_duedate) <= time()) {
		$class = " payment_notontime";
		$thestatus = 0;
		$label_class = "important";
	}
	else {
		$class = " payment_unpaid_ontime";
		$thestatus = 2;
		$label_class = "warning";
	}
}
elseif($this->payment->payment_duedate == "0000-00-00 00:00:00"){
	$thestatus = 2;
	$class = " payment_unpaid_ontime";
	$label_class = "warning";
}

if($this->payment->payment_status == 2){
	$thestatus = 3;
	$class = " payment_pending";
}

?>
<div class="page-header">
	<?php if($user->id) { ?> <a class="pull-right" href="<?php echo JRoute::_( 'index.php?option=com_invoices&view=invoices' ); ?>"><?php echo JText::_( 'RETURN_INVOICES' ); ?></a><?php } ?>
<h1><?php echo JText::_( 'PAYMENT' ); ?></h1>
</div>
<div class="row-fluid">
	<div class="span6">
<fieldset class="invoicesfieldset">
<legend><?php echo JText::_( 'PAYMENT_DETAILS' ); ?></legend>
<dl class="dl-horizontal">

	<dt><?php echo JText::_( 'PAYMENT_AMOUNT' ); ?></dt>
	<dd><?php echo InvoicesHelper::format($this->payment->payment_amount, (int)$this->payment->currency_id); ?></dd>

	<dt><?php echo JText::_( 'PAYMENT_CREATION' ); ?></dt>
	<dd><?php if($this->payment->created_datetime == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->created_datetime, JText::_('DATE_FORMAT_LC3'), false); ?></dd>

	<dt><?php echo JText::_( 'PAYMENT_DUEDATE' ); ?></dt>
	<dd><?php if($this->payment->payment_duedate == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->payment_duedate, JText::_('DATE_FORMAT_LC3'), false); ?></dd>

	<dt><?php echo JText::_( 'PAYMENT_DATETIME' ); ?></dt>
	<dd><?php if($this->payment->payment_datetime == "0000-00-00 00:00:00") echo JText::_('NOT_SETTED'); else echo JHTML::_('date', $this->payment->payment_datetime, JText::_('DATE_FORMAT_LC3'), false); ?></dd>

	<dt><?php echo JText::_( 'PAYMENT_DESCRIPTION' ); ?></dt>
	<dd><?php echo $this->payment->payment_description ? $this->payment->payment_description : "&nbsp;"; ?></dd>

	<dt><?php echo JText::_( 'PAID' ); ?></dt>
	<dd><?php echo $this->payment->payment_status ? JText::_('JYES') : JText::_('JNO'); ?></dd>

	<dt class="<?php echo $class; ?>"><?php echo JText::_( 'STATUS' ); ?></dt>
	<dd><span class="label label-<?php echo $label_class; ?>"><?php echo $payment_status[$thestatus]; ?></span></dd>


</dl>
</fieldset>
</div>
<div class="span6">

<?php if($thestatus != 1){ ?>
    <fieldset class="invoicesfieldset">
    <legend><?php echo JText::_( 'PAYMENT_OPTIONS' ); ?></legend>
    <?php
		// load the plugin
			$import = JPluginHelper::importPlugin( strtolower( 'Invoices' ) );
		// fire plugin
			$dispatcher = JDispatcher::getInstance();
			$the_payment_options = $dispatcher->trigger( 'onRenderPaymentOptions', array( $this->payment, $user ) );

			if(count($the_payment_options)){

				$pane = '1';

				echo JHtml::_('tabs.start', "pane_$pane");

				foreach($the_payment_options as $method){

					echo JHtml::_('tabs.panel', JText::_( $method[1] ), $method[1]);
					?>

                    <?php echo $method[0]; ?>
                    <?php

				}

				echo JHtml::_('tabs.end');

			}
			else echo JText::_( 'NO_PAYMENT_OPTIONS_AVAILABLE' );
		?>
    </fieldset>
<?php } ?>
</div>
</div>

<div align="center"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>
