<?php // no direct access

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$payment_status = InvoicesHelper::getPaymentStatus();

$user = JFactory::getUser();

?>

<h1><?php echo JText::_('INVOICES_TITLE'); ?></h1>

<form action="index.php" method="get" name="adminForm">
  <div class="table_scrolls">
    <table class="table table-striped table-hover items_table_responsive">
      <thead>
        <tr class="headerfinances">

          <th width="12%" class="hidden-phone"><?php echo JHTML::_( 'grid.sort', 'INVOICE_DATE', 'i.invoice_date', $this->lists['order_Dir'], $this->lists['order']); ?></th>
          <th width="12%"><?php echo JText::_('INVOICE_NUM'); ?></th>
          <th width="15%" class="hidden-phone"><?php echo JText::_('TO_NAME'); ?></th>
          <th width="10%" align="right" class="totals"><?php echo JText::_('SUBTOTAL'); ?></th>
          <th width="10%" align="right" class="totals"><?php echo JText::_('TOTAL'); ?></th>
          <th width="10%" align="right" class="hidden-phone"><?php echo JText::_('PAYMENTS'); ?></th>
          <th width="10%" align="right" class="totals"><?php echo JText::_('AMOUNT_PAID'); ?></th>

          <th width="10%"></th>
        </tr>
      </thead>
      <?php $k = 1;
      $number = $this->pagination->limitstart + 1 ;

      $total_global = 0 ;
      if(count($this->items)){
        for ($i = 0, $n=count( $this->items ); $i < $n; $i++) {

          $total_payments = $this->items[$i]->total_paid + $this->items[$i]->total_unpaid ;

          $class = "";

          if(round($this->items[$i]->total_paid,2) < round($this->items[$i]->total,2)) $class = " notontime";
          else $class = " ontime";

          ?>

          <tr class="linefinances<?php echo $k; ?> lineinvoice" id="lineinvoice_<?php echo $i; ?>" >

            <td class="hidden-phone"><?php echo JHTML::_('date', $this->items[$i]->invoice_date, JText::_('d/m/y'), false); ?></td>
            <td><?php echo $this->items[$i]->invoice_num; ?></td>
            <td class="hidden-phone"><?php echo $this->items[$i]->to_name; ?></td>
            <td align="right" class="amount"><?php echo InvoicesHelper::format($this->items[$i]->subtotal, $this->currencies[$this->items[$i]->currency_id]); ?></td>
            <td align="right" class="amount"><?php echo InvoicesHelper::format($this->items[$i]->total, $this->currencies[$this->items[$i]->currency_id]); ?></td>

            <td  align="right" class="hidden-phone">

              <?php echo JHTML::image('components/com_invoices/assets/images/view_price_details.png', JText::_('VIEW_INVOICE_PAYMENTS'), array("title" => JText::_('VIEW_INVOICE_PAYMENTS'), "class" => "payments_button hasTooltip", "id" => "payments_button_".$i, "data-original-title" => JText::_('VIEW_INVOICE_PAYMENTS'), "rel" => "tooltip")); ?>

              <span class="num_payments label <?php echo $this->items[$i]->paid_payments ? "label-success" : ""; ?>" title="<?php echo $this->items[$i]->paid_payments; ?> <?php echo JText::_('NUM_PAYMENTS_PAID'); ?>::<?php echo JText::_('TOTAL_AMOUNT'); ?>: <?php echo InvoicesHelper::format($this->items[$i]->total_paid, $this->currencies[$this->items[$i]->currency_id]); ?>"><?php echo $this->items[$i]->paid_payments; ?></span>

              <span class="num_payments label <?php echo $this->items[$i]->unpaid_payments_ontime ? "label-warning" : ""; ?>" title="<?php echo $this->items[$i]->unpaid_payments_ontime; ?> <?php echo JText::_('NUM_PAYMENTS_UNPAID_ONTIME'); ?>::<?php echo JText::_('TOTAL_AMOUNT'); ?>: <?php echo InvoicesHelper::format($this->items[$i]->total_unpaid_ontime, $this->currencies[$this->items[$i]->currency_id]); ?>"><?php echo $this->items[$i]->unpaid_payments_ontime; ?></span>

              <span class="num_payments label <?php echo ($this->items[$i]->unpaid_payments - $this->items[$i]->unpaid_payments_ontime) ? "label-important" : ""; ?>" title="<?php echo ($this->items[$i]->unpaid_payments - $this->items[$i]->unpaid_payments_ontime); ?> <?php echo JText::_('NUM_PAYMENTS_UNPAID'); ?>::<?php echo JText::_('TOTAL_AMOUNT'); ?>: <?php echo InvoicesHelper::format(($this->items[$i]->total_unpaid - $this->items[$i]->total_unpaid_ontime), $this->currencies[$this->items[$i]->currency_id]); ?>"><?php echo ($this->items[$i]->unpaid_payments - $this->items[$i]->unpaid_payments_ontime); ?></span>
            </td>


            <td align="right" class="<?php echo $class; ?> amount"><?php echo InvoicesHelper::format($this->items[$i]->total_paid, $this->currencies[$this->items[$i]->currency_id]); ?></td>
            <td><?php echo InvoicesHelper::view_modal_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::view_online_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::download_pdf_button($this->items[$i]->id); ?> <?php echo InvoicesHelper::send_email_button($this->items[$i]->id); ?></td>
          </tr>

          <?php

          $k = 3 - $k;
          $number++;

        }
      }
      else{ ?>
      <tr class="linefinances1" >
        <td align="center" colspan="8"><?php echo JText::_('NO_INVOICES_AVAILABLE'); ?></td>
      </tr>
      <?php } ?>
      <tfoot>
        <tr class="footfinances">
          <td class="hidden-phone"></td>
          <td></td>
          <td class="hidden-phone"></td>
          <td></td>
          <td></td>
          <td class="totals" align="right"></td>
          <td class="hidden-phone"></td>
          <td class="totals" align="right"></td>
        </tr>
      </tfoot>
    </table>
  </div>
  <input type="hidden" name="option" value="com_invoices" />
  <input type="hidden" name="view" value="invoices" />
  <input type="hidden" name="filter_order" value="<?php echo JRequest::getVar('filter_order'); ?>" />
  <input type="hidden" name="filter_order_Dir" value="<?php echo JRequest::getVar('filter_order_Dir'); ?>" />
  <div class="pagination" align="center"> <?php echo $this->pagination->getListFooter(); ?> </div>
</form>

<h2><?php echo JText::_('PAYMENTS_TITLE'); ?></h2>
<p><?php echo JText::sprintf('PAYMENTS_EXPLANATION', JHTML::image('components/com_invoices/assets/images/view_price_details.png', JText::_('VIEW_INVOICE_PAYMENTS'))); ?> <a class="btn pull-right disabled" id="allpayments_button" href="javascript:see_all_payments()"><?php echo JText::_('SEE_ALL_PAYMENTS'); ?></a></p>


<div class="table_scrolls">
  <table class="table table-striped table-hover items_table_responsive">
    <thead>
      <tr class="headerfinances">

        <th width="12%"><?php echo JText::_('INVOICE_NUM'); ?></th>
        <th width="12%" class="hidden-phone"><?php echo JText::_('DUE_DATE'); ?></th>
        <th width="12%" class="hidden-phone"><?php echo JText::_('PAYMENT_DATETIME'); ?></th>
        <th width="10%" class="hidden-phone"><?php echo JText::_('PAYMENT_METHOD'); ?></th>

        <th width="12%" align="right" class="amount"><?php echo JText::_('PAYMENT_AMOUNT'); ?></th>
        <th width="5%" class="hidden-phone" class="amount"><?php echo JText::_('PAID'); ?></th>
        <th width="15%" ><?php echo JText::_('STATUS'); ?></th>
        <th width="12%"></th>

      </tr>
    </thead>
    <?php


    $total_global = 0 ;
    if(count($this->items)){
      for ($i = 0, $n=count( $this->items ); $i < $n; $i++) {

        $class = "";

        if(count($this->items[$i]->payments)){

          foreach($this->items[$i]->payments as $payment){

            $thestatus = InvoicesHelper::getThePaymentStatus($payment) ;

            switch($thestatus){
              case 0:
              $class = " payment_notontime";
              $trclass = "error";
              break;
              case 1:
              $class = " payment_paid";
              $trclass = "success";
              break;
              case 2:
              $class = " payment_unpaid_ontime";
              $trclass = "warning";
              break;
              case 3:
              $class = " payment_pending";
              $trclass = "";
              break;
            }

            $statuslabel = InvoicesHelper::render_status_payment($thestatus) ;

            $link_payment = JRoute::_('index.php?option=com_invoices&view=payment&id='.$payment->id);

            ?>

            <tr class="paymentline payment_<?php echo $i; ?> linefinances<?php echo $k; ?>  <?php echo $class; ?> <?php echo $trclass; ?>" >

              <td><?php echo $this->items[$i]->invoice_num; ?></td>

              <?php if($payment->payment_duedate == "0000-00-00 00:00:00") {$text = JText::_('NOT_SETTED'); $td_class = "notsetted";} else {$text = JHTML::_('date', $payment->payment_duedate, JText::_('DATE_FORMAT_PAYMENTS'), false); $td_class = "";} ?>
              <td class="hidden-phone duedateline <?php echo $td_class; ?>"><?php echo $text; ?></td>

              <?php if($payment->payment_datetime == "0000-00-00 00:00:00") {$text = JText::_('NOT_SETTED'); $td_class = "notsetted";} else {$text = JHTML::_('date', $payment->payment_datetime, JText::_('DATE_FORMAT_PAYMENTS'), false); $td_class = "";} ?>
              <td class="hidden-phone <?php echo $td_class; ?>"><?php echo $text; ?></td>

              <?php if($payment->payment_type == "") {$text = JText::_('NOT_SPECIFIED'); $td_class = "notsetted";} else {$text = JText::_($payment->payment_type); $td_class = "";} ?>
              <td class="hidden-phone <?php echo $td_class; ?>"><?php echo $text; ?></td>

              <td align="right" class="amount text-right"><?php echo InvoicesHelper::format($payment->payment_amount, $this->currencies[$this->items[$i]->currency_id]); ?></td>

              <td class="hidden-phone"><?php echo $payment->payment_status ? JText::_('JYES') : JText::_('JNO'); ?></td>

              <td class="statussentence"><?php echo $statuslabel; ?></td>
              <td><?php if( !$payment->payment_status) { ?><a class=" btn btn-small btn-block" href="<?php echo $link_payment; ?>"><i class="icon-arrow-right"></i> <?php echo JText::_('PAY'); ?></a><?php } else{ ?><a class="btn-block btn btn-small" href="<?php echo $link_payment; ?>"><i class="icon-eye-open"></i> <?php echo JText::_('VIEW_PAYMENT_DETAILS'); ?></a><?php } ?>
              </td>

            </tr>

            <?php

          }
        }
      }
    }

    else{ ?>
    <tr class="linefinances1" >
      <td align="center" colspan="8"><?php echo JText::_('NO_PAYMENTS_AVAILABLE'); ?></td>
    </tr>
    <?php } ?>
    <tfoot>
      <tr class="footfinances">
        <td></td>
        <td class="hidden-phone"></td>
        <td class="hidden-phone"></td>
        <td class="hidden-phone"></td>
        <td class="totals" align="right"></td>
        <td class="hidden-phone "></td>
        <td></td>

        <td></td>
      </tr>
    </tfoot>
  </table>
</div>

<h1><?php echo JText::_('QUOTES_TITLE'); ?></h1>

<div class="table_scrolls">
  <table class="table table-striped table-hover items_table_responsive">
    <thead>
      <tr class="headerfinances">

        <th width="12%" class="hidden-phone"><?php echo JHTML::_( 'grid.sort', 'QUOTE_DATE', 'i.invoice_date', $this->lists['order_Dir'], $this->lists['order']); ?></th>
        <th width="12%"><?php echo JText::_('QUOTE_NUM'); ?></th>
        <th width="15%" class="hidden-phone"><?php echo JText::_('TO_NAME'); ?></th>
        <th width="10%" align="right" class="totals"><?php echo JText::_('SUBTOTAL'); ?></th>
        <th width="10%" align="right" class="totals"><?php echo JText::_('TOTAL'); ?></th>
        <th width="10%" align="right" class="totals"><?php echo JText::_('STATUS'); ?></th>
        <th width="10%"></th>
      </tr>
    </thead>
    <?php $k = 1;

    $total_global = 0 ;
    if(count($this->quotes)){
      for ($i = 0, $n=count( $this->quotes ); $i < $n; $i++) {

       ?>

       <tr class="linequote<?php echo $k; ?> linequote" id="linequote_<?php echo $i; ?>" >

        <td class="hidden-phone"><?php echo JHTML::_('date', $this->quotes[$i]->invoice_date, JText::_('d/m/y'), false); ?></td>
        <td><?php echo $this->quotes[$i]->invoice_num; ?></td>
        <td class="hidden-phone"><?php echo $this->quotes[$i]->to_name; ?></td>
        <td align="right" class="amount"><?php echo InvoicesHelper::format($this->quotes[$i]->subtotal, $this->currencies[$this->quotes[$i]->currency_id]); ?></td>
        <td align="right" class="amount"><?php echo InvoicesHelper::format($this->quotes[$i]->total, $this->currencies[$this->quotes[$i]->currency_id]); ?></td>
        <td align="right" ><?php echo InvoicesHelper::render_status($this->quotes[$i]->status); ?></td>
        <td><?php echo InvoicesHelper::view_modal_button($this->quotes[$i]->id); ?> <?php echo InvoicesHelper::view_online_button($this->quotes[$i]->id); ?> <?php echo InvoicesHelper::download_pdf_button($this->quotes[$i]->id); ?> <?php echo InvoicesHelper::send_email_button($this->quotes[$i]->id,'quote'); ?></td>
      </tr>

      <?php

      $k = 3 - $k;
      $number++;

    }
  }
  else{ ?>
  <tr class="linefinances1" >
    <td align="center" colspan="7"><?php echo JText::_('NO_QUOTES_AVAILABLE'); ?></td>
  </tr>
  <?php } ?>
  <tfoot>
    <tr class="footfinances">
      <td class="hidden-phone"></td>
      <td></td>
      <td class="hidden-phone"></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
    </tr>
  </tfoot>
</table>
</div>

<br />
<?php
if(JRequest::getVar('option') != 'com_easysocial') {
  $modules = JModuleHelper::getModules("invoices_bottom");
  $document = JFactory::getDocument();
  $renderer = $document->loadRenderer('module');
  $attribs  = array();
  $attribs['style'] = 'xhtml';
  foreach ( @$modules as $mod )
  {
    echo $renderer->render($mod, $attribs);
  }
}

?>

<div align="center"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>
