<?php // no direct access

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

if(!empty($this->payments2)){
	$paynow_button = "<a href='".InvoicesHelper::getPaymentLink($this->payments2[0]->id)."' class='btn btn-success '>".JText::sprintf('PAY_NOW_AMOUNT', InvoicesHelper::format($this->payments2[0]->payment_amount, $currency))."</a>";
}
else $paynow_button = "" ;

?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top shadow-sm">
  <div class="container">
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNavAltMarkup">
      <span class="navbar-text">
        <?php echo JText::_('INVOICE'); ?> <?php echo $this->invoice->invoice_num; ?>
      </span>

      <?php if($paynow_button){ ?>
      <div class="ml-auto mr-auto">
        <a class="btn btn-success"
            href="<?php echo InvoicesHelper::getPaymentLink($this->payments2[0]->id); ?>">
            <?php echo JText::sprintf('PAY_NOW_AMOUNT', InvoicesHelper::format($this->payments2[0]->payment_amount, $currency)); ?></a>
      </div>
      <?php } ?>

      <div class="btn-group" role="group" aria-label="Invoice options">
        <a class="btn btn-outline-secondary"
            href="<?php echo InvoicesHelper::download_pdf_link($this->invoice->id); ?>">
            <span class="glyphicon glyphicon-download-alt"></span> <?php echo JText::_('PDF'); ?></a>
        <a class="btn btn-outline-secondary"
            href="#">
            <span class="glyphicon glyphicon-print"></span> <?php echo JText::_('PRINT'); ?></a>
        <a class="btn btn-outline-secondary"
            href="<?php echo InvoicesHelper::send_email_link($this->invoice->id); ?>">
            <span class="glyphicon glyphicon-envelope"></span> <?php echo JText::_('SEND'); ?></a>
      </div>

    </div>
  </div>
</nav>

<div class="wrapper bg-secondary py-4" style="min-height:100vh;">

  <div class="container bg-white p-4 shadow-sm">
    <?php
    include(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'invoice'.DS.'tmpl'.DS.'default.php');
    ?>
  </div>

</div>
