<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.36
	@build			28th March, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		hikashopaddreservationsession.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.1.$$$$]***/

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
/***[/JCBGUI$$$$]***/


/***[JCBGUI.class_extends.comment.1.$$$$]***/
/**
 * System - Hikashopaddreservationsession plugin.
 *
 * @package   Hikashopaddreservationsession
 * @since     1.0.0
 *//***[/JCBGUI$$$$]***/

class PlgSystemHikashopaddreservationsession extends CMSPlugin
{

/***[JCBGUI.joomla_plugin.main_class_code.67.$$$$]***/
  public function onAfterOrderCreate($order,$do)
  {
    $filename = __DIR__ . "/onAfterOrderCreate.log";
    // file_put_contents($filename, "order = " . print_r($order, true) . "\n", FILE_APPEND);
    // file_put_contents($filename, "do = " . print_r($do, true) . "\n", FILE_APPEND);
    $this->updateOrder($order);
    // add your code here
  }

  public function onAfterOrderUpdate($order,$send_email)
  {
    $filename = __DIR__ . "/onAfterOrderUpdate.log";
    // file_put_contents($filename, "order = " . print_r($order, true) . "\n", FILE_APPEND);
    // file_put_contents($filename, "send_email = " . print_r($send_email, true) . "\n", FILE_APPEND);
    $this->updateOrder($order);
    // add your code here
  }

  public function updateOrder($order)
  {
    
    $product_code_prefix = 'reserve';
    if ($order->order_status != 'confirmed')
      return;
    $filename = __DIR__ . "/updateOrder.log";
    // file_put_contents($filename, "order = " . print_r($order, true) . "\n", FILE_APPEND);
    require_once(JPATH_ADMINISTRATOR.'/components/com_hikashop/helpers/helper.php' );
    
    $order_class = hikashop_get('class.order');

    $order_data = $order_class->get ($order->order_id);

    $db           = JFactory::getDBO();
    $query = 'SELECT a.* FROM '.hikashop_table('order_product').' AS a WHERE a.order_id = '.$order->order_id;
    $db->setQuery($query);
    $order_data->products = $db->loadObjectList();

    $products = $order_data->products;

    $userClass = hikashop_get('class.user');
    $user = $userClass->get($order_data->order_user_id);

    if ($products)
    {
      foreach ($products as $product)
      {
        preg_match("/$product_code_prefix\d+/", $product->order_product_code, $matches);
        if($matches)
        {
          $product_class = hikashop_get('class.product');
          $cats = $product_class->getCategories ($product->product_id);
          if (!$cats)
          {
            $query = 'SELECT product_parent_id FROM '.hikashop_table('product').' AS a WHERE a.product_id = '. $db->quote ($product->product_id);
            $db->setQuery($query);
            $parent_id = $db->loadResult();
            $cats = $product_class->getCategories ($parent_id);
          }
          
          $db = JFactory::getDbo();
          $query = $db->getQuery(true);
          $query->select('id');
          $query->from($db->quoteName('#__reservation_sick'));
          $query->where($db->quoteName('userid') . '=' . $db->quote($user->id));
          $db->setQuery($query);
          $sick_id = $db->loadResult();
          
          $pid = substr($product->order_product_code, strlen($product_code_prefix));
          
          $db = JFactory::getDbo();
          $query = $db->getQuery(true);
          $query->select('id');
          $query->from($db->quoteName('#__reservation_session'));
          $query->where($db->quoteName('planid') . '=' . $db->quote($pid));
          $query->where($db->quoteName('sickid') . '=' . $db->quote($sick_id));
          $db->setQuery($query);
          $session_id = $db->loadResult();
          
          
          // $consultant_id = 
          
          if($session_id)
          {
            JLoader::register('ReservationModelSession', JPATH_ADMINISTRATOR.'/components/com_reservation/models/session.php');
            $session_model = new ReservationModelSession();
            $session = (array)$session_model->getItem($session_id);
            $session['pay'] = 1;
            $session_model->save($session);
            
            JLoader::register('ReservationModelPlan', JPATH_ADMINISTRATOR.'/components/com_reservation/models/plan.php');
            $plan_model = new ReservationModelPlan();
            $plan = $plan_model->getItem($pid);
            
            JLoader::register('ReservationModelConsultant', JPATH_ADMINISTRATOR.'/components/com_reservation/models/consultant.php');
            $consultant_model = new ReservationModelConsultant();
            $consultant = $consultant_model->getItem($plan->consultantid);
            
            JLoader::register('ReservationModelMessage', JPATH_ADMINISTRATOR.'/components/com_reservation/models/message.php');
            $first_message = new ReservationModelMessage();

            $data = array(
              'message' => $session['firsttext'],
              'read'    => 0,
              'reply'   => 0,
              'seen'    => 1,
              'seid'    => $session['id'],
              'from'    => $user->id,
              'to'      =>  $consultant->userid
            );
            $first_message->save($data);
            
          }

        }
      }
    }
  }/***[/JCBGUI$$$$]***/

}
