vider;

use Joomla\CMS\Cache\CacheControllerFactoryInterface;
use Joomla\CMS\Menu\MenuFactory;
use Joomla\CMS\Menu\MenuFactoryInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Service provider for the application's menu dependency
 *
 * @since  4.0.0
 */
class Menu implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->alias('menu.factory', MenuFactoryInterface::class)
            ->alias(MenuFactory::class, MenuFactoryInterface::class)
            ->share(
                MenuFactoryInterface::class,
                function (Container $container) {
                    $factory = new MenuFactory();
                    $factory->setCacheControllerFactory($container->get(CacheControllerFactoryInterface::class));
                    $factory->setDatabase($container->get(DatabaseInterface::class));

                    return $factory;
                },
                true
            );
    }
}
PK     -[~    %  Service/Provider/WebAssetRegistry.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Pub