vider;

use Joomla\CMS\Form\FormFactory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Service provider for the form dependency
 *
 * @since  4.0.0
 */
class Form implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->alias('form.factory', FormFactoryInterface::class)
            ->alias(FormFactory::class, FormFactoryInterface::class)
            ->share(
                FormFactoryInterface::class,
                function (Container $container) {
                    $factory = new FormFactory();
                    $factory->setDatabase($container->get(DatabaseInterface::class));

                    return $factory;
                },
                true
            );
    }
}
PK     -[=      Service/Provider/Database.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright   (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public Li