s;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\FileLayout;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Utility class for icons.
 *
 * @since  2.5
 */
abstract class Icons
{
    /**
     * Method to generate html code for a list of buttons
     *
     * @param   array  $buttons  Array of buttons
     *
     * @return  string
     *
     * @since   2.5
     */
    public static function buttons($buttons)
    {
        if (empty($buttons)) {
            return '';
        }

        $html = [];

        foreach ($buttons as $button) {
            $html[] = HTMLHelper::_('icons.button', $button);
        }

        return implode($html);
    }

    /**
     * Method to generate html code for a list of buttons
     *
     * @param   array  $button  Button properties
     *
     * @return  string
     *
     * @since   2.5
     */
    public static function button($button)
    {
        if (isset($button['access'])) {
            if (\is_bool($button['access'])) {
                if ($button['access'] == false) {
                    return '';
                }
            } else {
                // Get the user object to verify permissions
                $user = Factory::getUser();

                // Take each pair of permission, context values.
                for ($i = 0, $n = \count($button['access']); $i < $n; $i += 2) {
                    if (!$user->authorise($button['access'][$i], $button['access'][$i + 1])) {
                        return '';
                    }
                }
            }
        }

        // Instantiate a new FileLayout instance and render the layout
        $layout = new FileLayout('joomla.quickicons.icon');

        return $layout->render($button);
    }
}
PK     6[
	  	    HTML/Helpers/Email.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License ver