ervice\Provider;

use Joomla\CMS\Dispatcher\ModuleDispatcherFactoryInterface;
use Joomla\CMS\Extension\ModuleInterface;
use Joomla\CMS\Helper\HelperFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Service provider for the service based modules.
 *
 * @since  4.0.0
 */
class Module implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->set(
            ModuleInterface::class,
            function (Container $container) {
                return new \Joomla\CMS\Extension\Module(
                    $container->get(ModuleDispatcherFactoryInterface::class),
                    $container->has(HelperFactoryInterface::class) ? $container->get(HelperFactoryInterface::class) : null
                );
            }
        );
    }
}
PK     6[@GK  K  ,  Extension/Service/Provider/HelperFactory.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2021 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU Gene