

use Joomla\CMS\Event\Result\ResultAware;
use Joomla\CMS\Event\Result\ResultAwareInterface;
use Joomla\CMS\Event\Result\ResultTypeBooleanAware;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Class for User save event.
 * Example:
 *  new BeforeSaveEvent('onEventName', ['subject' => $oldUserArray, 'isNew' => $isNew, 'data' => $data]);
 *
 * @since  5.0.0
 */
class BeforeSaveEvent extends AbstractSaveEvent implements ResultAwareInterface
{
    use ResultAware;
    use ResultTypeBooleanAware;

    /**
     * The argument names, in order expected by legacy plugins.
     *
     * @var array
     *
     * @since  5.0.0
     * @deprecated 5.0 will be removed in 6.0
     */
    protected $legacyArgumentsOrder = ['subject', 'isNew', 'data'];

    /**
     * Setter for the data argument.
     *
     * @param   array  $value  The value to set
     *
     * @return  array
     *
     * @since  5.0.0
     */
    protected function onSetData(array $value): array
    {
        return $value;
    }

    /**
     * Getter for the data.
     *
     * @return  array
     *
     * @since  5.0.0
     */
    public function getData(): array
    {
        return $this->arguments['data'] ?? [];
    }
}
PK     1[|1z	  z	    Event/User/AfterDeleteEvent.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public Li