pi;

use Joomla\CMS\MVC\Controller\Exception\SendEmail;
use Tobscure\JsonApi\Exception\Handler\ExceptionHandlerInterface;
use Tobscure\JsonApi\Exception\Handler\ResponseBag;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Handler for error when send email
 *
 * @since  4.0.0
 */
class SendEmailExceptionHandler implements ExceptionHandlerInterface
{
    /**
     * If the exception handler is able to format a response for the provided exception,
     * then the implementation should return true.
     *
     * @param   \Exception  $e  The exception to be handled
     *
     * @return  boolean
     *
     * @since  4.0.0
     */
    public function manages(\Exception $e)
    {
        return $e instanceof SendEmail;
    }

    /**
     * Handle the provided exception.
     *
     * @param   \Exception  $e  The exception being handled
     *
     * @return  \Tobscure\JsonApi\Exception\Handler\ResponseBag
     *
     * @since  4.0.0
     */
    public function handle(\Exception $e)
    {
        $status = 400;

        if ($e->getCode()) {
            $status = $e->getCode();
        }

        $error = ['title' => $e->getMessage()];

        return new ResponseBag($status, [$error]);
    }
}
PK     6[8,4  4  2  Error/JsonApi/ResourceNotFoundExceptionHandler.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2019 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GN