outer;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Menu\AbstractMenu;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Trait to implement AssociationServiceInterface
 *
 * @since  4.0.0
 */
trait RouterServiceTrait
{
    /**
     * The router factory.
     *
     * @var RouterFactoryInterface
     *
     * @since  4.0.0
     */
    private $routerFactory = null;

    /**
     * Returns the router.
     *
     * @param   CMSApplicationInterface  $application  The application object
     * @param   AbstractMenu             $menu         The menu object to work with
     *
     * @return  RouterInterface
     *
     * @since  4.0.0
     */
    public function createRouter(CMSApplicationInterface $application, AbstractMenu $menu): RouterInterface
    {
        return $this->routerFactory->createRouter($application, $menu);
    }

    /**
     * The router factory.
     *
     * @param   RouterFactoryInterface  $routerFactory  The router factory
     *
     * @return  void
     *
     * @since  4.0.0
     */
    public function setRouterFactory(RouterFactoryInterface $routerFactory)
    {
        $this->routerFactory = $routerFactory;
    }
}
PK     6[وX  X    Console/SiteDownCommand.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public Licens