use Composer\Autoload\ClassLoader as ComposerClassLoader;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Decorate Composer ClassLoader for Joomla!
 *
 * For backward compatibility due to class aliasing in the CMS, the loadClass() method was modified to call
 * the JLoader::applyAliasFor() method.
 *
 * @since  3.4
 */
class ClassLoader
{
    /**
     * The Composer class loader
     *
     * @var    ComposerClassLoader
     * @since  3.4
     */
    private $loader;

    /**
     * Constructor
     *
     * @param   ComposerClassLoader  $loader  Composer autoloader
     *
     * @since   3.4
     */
    public function __construct(ComposerClassLoader $loader)
    {
        $this->loader = $loader;
    }

    /**
     * Loads the given class or interface.
     *
     * @param   string  $class  The name of the class
     *
     * @return  boolean|null  True if loaded, null otherwise
     *
     * @since   3.4
     */
    public function loadClass($class)
    {
        if ($result = $this->loader->loadClass($class)) {
            \JLoader::applyAliasFor($class);
        }

        return $result;
    }
}
PK     6[* !    #  Categories/CategoryServiceTrait.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Publi