ion\Password;

use Joomla\Authentication\Password\Argon2idHandler as BaseArgon2idHandler;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Password handler for Argon2id hashed passwords
 *
 * @since  4.0.0
 */
class Argon2idHandler extends BaseArgon2idHandler implements CheckIfRehashNeededHandlerInterface
{
    /**
     * Check if the password requires rehashing
     *
     * @param   string  $hash  The password hash to check
     *
     * @return  boolean
     *
     * @since   4.0.0
     */
    public function checkIfRehashNeeded(string $hash): bool
    {
        return password_needs_rehash($hash, PASSWORD_ARGON2ID);
    }
}
PK     ,[\G%    =  Authentication/ProviderAwareAuthenticationPluginInterface.phpnu [        <?php

/**
 * Joomla! Content Management System
 *
 * @copyright  Copyright (C) 2022 Open Source Matters, Inc. All rights reserved.
