<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    30th April, 2015
 * @author     Llewellyn van der Merwe <https://dev.vdm.io>
 * @git        Joomla Component Builder <https://git.vdm.dev/joomla/Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JLoader::register('ComponentbuilderHelper', JPATH_ADMINISTRATOR . '/components/com_componentbuilder/helpers/componentbuilder.php'); 

use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;

/**
 * Content - Componentbuilder Field Ordering Tabs plugin.
 *
 * @package   ComponentbuilderFieldOrderingTabs
 * @since     1.0.3
 */
class PlgContentComponentbuilderFieldOrderingTabs extends CMSPlugin
{
	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 * @since  1.0
	 */
	protected  $autoloadLanguage = true;

	/**
	 * Runs on content preparation of form.
	 *
	 * @param   JForm     $form  The form
	 * @param   stdClass  $data  The data
	 *
	 * @return  boolean
	 *
	 * @since   1.0
	 */
	public function onContentPrepareForm(Form $form, $data)
	{
		$context = $form->getName();

		// When this is componentbuilder admin view
		if (strpos($context, 'com_componentbuilder.admin_view') === 0)
		{
			// Add the forms path
			Form::addFormPath(__DIR__ . '/forms');
			// add the admin view params for privacy integration
			$form->loadFile('admin_view');
		}
		return true;
	}
}
