<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.94
	@build			23rd July, 2023
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		send_by_bale.php
	@author			Lmskaran <https://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.1.$$$$]***/
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
/***[/JCBGUI$$$$]***/


/***[JCBGUI.class_extends.comment.1.$$$$]***/
/**
 * Chat - Send_by_bale plugin.
 *
 * @package   Send_by_bale
 * @since     1.0.0
 *//***[/JCBGUI$$$$]***/

class PlgChatSend_by_bale extends CMSPlugin
{

/***[JCBGUI.joomla_plugin.main_class_code.104.$$$$]***/
public function afterChatSave($data)
{
	$filename = __DIR__ . '/log.txt';
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query
        ->select(array('bale_id', 'firstname', 'middlename', 'lastname'))
        ->from($db->quoteName('#__send_by_bale', 'b'))
        ->join('INNER', $db->quoteName('#__comprofiler', 'p') . ' ON ' . $db->quoteName('b.mobile') . ' = ' . $db->quoteName('p.cb_mobilenumber'))
        ->where($db->quoteName('p.user_id') . ' = ' . $db->quote($data['to']));

    $db->setQuery($query);
    $result = $db->loadObject();
	// file_put_contents($filename, 'result = ' . print_r($result, True), FILE_APPEND);

    if (empty($result))
        return false;

    if ((!file_exists(JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php')) || (!file_exists(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php'))) {
         echo 'CB not installed in send_by_bale plugin';
        $imgurl = '';
    } else {
        include_once(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php');

        cbimport('cb.html');
        global $_CB_framework, $_PLUGINS, $ueConfig;

        $cbUser = &CBuser::getInstance((int) $data['from']);
        $user = $cbUser->getUserData();
        $imgurl = '/images/comprofiler/' . $user->avatar;
    }

    $uri= juri::getinstance();
    $host= $uri->getHost();
    $chatLink= $host."/component/reservation/login?backView=messages!uid={$data['from']}!pid={$data['pid']}!seid={$data['seid']}";
    $text= "شما یک پیام از طرف {$user->get('name')} دارید.\nلینک صفحه گفتگو:\n {$chatLink}";


    require_once __DIR__ . '/classes/send.php';
    $data = [[
        'chat_id' => $result->bale_id,
        'text' => $text
    ]];

    send::send_bale_message($data);


}/***[/JCBGUI$$$$]***/

}
