<?php

if (!empty($_POST)) {
    // Filter the excel data
    function filterData(&$str)
    {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }


    require_once $_SERVER['DOCUMENT_ROOT'] . '/tm/db.php';
    $database = new db;

    $receive = explode('_', $_POST['type'])[0];
    $ticket = explode('_', $_POST['type'])[1];

    $sql = 'select name, mobile, email, ticket, receive from users where receive=' . $receive . ' and ticket=' . $ticket;
    $data= $database->query($sql, 'r', 'all');


    // Excel file name for download
    $fileName = "{$receive}_{$ticket}_" . date('Y-m-d') . ".xls";

    // Column names
    $fields = array('نام', 'شماره تلفن', 'ایمیل', 'بلیط', 'محل دریافت بسته');
    $ticket_list= [0=>'ندارم', 1=> 'دارم'];
    $receive_list= [1=> 'رایزنی فرهنگی جمهوری اسلامی ایران در قطر',2=> 'سرپرست مدارس ایرانیان در قطر', 3=> 'سفارت جمهوری اسلامی ایران'] ;


    // Display column names as first row
    $excelData = implode("\t", array_values($fields)) . "\n";

    if (!empty($data)) {
        // Output each row of the data
        foreach ($data as $row) {
            $lineData = array($row['name'], $row['mobile'], $row['email'], $ticket_list[$row['ticket']], $receive_list[$row['receive']]);
            array_walk($lineData, 'filterData');
            $excelData .= implode("\t", array_values($lineData)) . "\n";
        }
    } else {
        $excelData .= 'No records found...' . "\n";
    }

    // Headers for download
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$fileName\"");

    // Render excel data
    echo $excelData;
}

?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>پنل مدیریت ربات رایزن</title>
    <style>

        form{
            margin: 40px 0;
            text-align: center;
        }


    </style>
</head>
<body>

<div>

    <form action="" method="post">
        <input type="hidden" name="type" value="1_1"/>
        <input id="submit" type="submit" value="رایزنی فرهنگی | بلیط دارد">
    </form>
    <form action="" method="post">
        <input type="hidden" name="type" value="1_0"/>
        <input id="submit" type="submit" value="رایزنی فرهنگی | بلیط ندارد">
    </form>

    <form action="" method="post">
        <input type="hidden" name="type" value="2_1"/>
        <input id="submit" type="submit" value="سرپرست مدارس | بلیط دارد">
    </form>
    <form action="" method="post">
        <input type="hidden" name="type" value="2_0"/>
        <input id="submit" type="submit" value="سرپرست مدارس | بلیط ندارد">
    </form>

    <form action="" method="post">
        <input type="hidden" name="type" value="3_1"/>
        <input id="submit" type="submit" value="سفارت | بلیط دارد">
    </form>
    <form action="" method="post">
        <input type="hidden" name="type" value="3_0"/>
        <input id="submit" type="submit" value="سفارت | بلیط ندارد">
    </form>
    
</div>


</body>
</html>
