<style>
    /* slider css code */

    .slider-container {
        position: relative;
        display: flex;
        justify-content: space-between;
        /* padding: 1em; */
        overflow: hidden;
    }

    .slider-container::before {
        position: absolute;
        /* top: calc(50% - 22px); */
        top: 14px;
        right: 65px;
        left: 65px;
        content: "";
        background-color: #d8d8d8;
        height: 1px;
        z-index: 0;
    }
    .slider-item{
        z-index: 1;
    }

    @media (max-width: 768px) {
        .slider-container::before {
            /* top: calc(50% - 22px); */
            top: 12px;
            right: 60px;
            left: 60px;
        }
    }


    /* this are custom css classes we use at work */

    .wi-12 {
        width: 12px;
    }

    .he-12 {
        height: 12px;
    }

    .wi-24 {
        width: 24px;
    }

    .he-24 {
        height: 24px;
    }

    @media (min-width: 768px) {
        .wi-md-20 {
            width: 20px;
        }
        .he-md-20 {
            height: 20px;
        }
        .wi-md-30 {
            width: 30px;
        }
        .he-md-30 {
            height: 30px;
        }
        .wi-md-100 {
            width: 100px;
        }
    }

    .wi-70 {
        width: 70px;
    }

    .bg-green-700 {
        background-color: #00bf79;
    }

    .bg-gray-300 {
        background-color: #bababa;
    }

    .bor-rounded-full {
        border-radius: 50%;
    }

    .font-Roboto {
        font-family: "Roboto";
    }

    .fs-10 {
        font-size: 10px;
    }

    .fs-md-12 {
        font-size: 12px;
    }


</style>


<?php if (!$user->guest): ?>

    <div class="
                text-center
                mt-md-4
                px-4
                d-flex
                align-items-start
                justify-content-between
                slider-container
                mb-md-3
              ">
        <div class="slider-item wi-md-100">
            <div class="
                    wi-24
                    he-24
                    wi-md-30
                    he-md-30
                    bor-rounded-full
                    d-inline-flex
                    justify-content-center
                    align-items-center
                  " style="
                   background: rgba(0, 191, 121, 0.3);
                  ">
                <div class="wi-12 he-12 wi-md-20 he-md-20 bg-green-700 bor-rounded-full d-inline-block"></div>
            </div>
            <p class="m-0 fs-10 fs-md-12 mt-2 p-1">
                ارسال <br /> درخواست
            </p>
        </div>
        <div class="slider-item wi-md-100">
            <div class="
                    wi-24
                    he-24
                    wi-md-30
                    he-md-30
                    bor-rounded-full
                    d-inline-flex
                    justify-content-center
                    align-items-center
                  " style="background: rgba(0, 191, 121, 0.3);">
                <div class="wi-12 he-12 wi-md-20 he-md-20 bor-rounded-full d-inline-block bg-green-700"></div>
            </div>
            <p class="m-0 fs-10 fs-md-12 mt-2 p-1">
                در حال پذیرش <br/> درخواست شما توسط مشاور
            </p>
        </div>
        <div class="slider-item wi-md-100">
            <div class="
                    wi-24
                    he-24
                    wi-md-30
                    he-md-30
                    bor-rounded-full
                    d-inline-flex
                    justify-content-center
                    align-items-center
                  ">
                <div class="wi-12 he-12 wi-md-20 he-md-20 bg-gray-300 bor-rounded-full d-inline-block"></div>
            </div>
            <p class="m-0 fs-10 fs-md-12 mt-2 p-1">
                انتخاب مشاور نهایی <br/> توسط شما
            </p>
        </div>
        <div class="slider-item wi-md-100">
            <div class="
                    wi-24
                    he-24
                    wi-md-30
                    he-md-30
                    bor-rounded-full
                    d-inline-flex
                    justify-content-center
                    align-items-center
                  ">
                <div class="wi-12 he-12 wi-md-20 he-md-20 bg-gray-300 bor-rounded-full d-inline-block"></div>
            </div>
            <p class="m-0 fs-10 fs-md-12 mt-2 p-1">
                پرداخت <br/> و شروع مشاوره
            </p>
        </div>
    </div>

<?php endif; ?>

<div class="container mt-5 mb-3">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-subtitle text-muted mt-1 me-1">مشاوره اورژانسی،
                        زمینه: <?= $cb_user->get('cb_emergency_topic'); ?></h6>
                    <img src="/modules/mod_emergencyconsultant/tmpl/assets/img/robot-searching.gif"
                         alt="robot searching for consultant image"
                         class="mt-3 mx-auto d-block">
                    <h5 class="card-title text-center pb-2">داریم برای شما دنبال مشاور میگردیم.</h5>
                    <div class="mt-4 text-center">
                        <p>
                            حداکثر زمان انتظار:
                        </p>
                    </div>
                    <div class="text-center mb-4">
                        <div style="direction: ltr;" class="countdown px-4 py-3 pb-4 d-inline-block"
                             data-date=""
                             data-time=""></div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>

<script>

    jQuery(document).ready(function ($) {

        let token = Joomla.getOptions('csrf.token')

        function loadInformation() {
            let intervId= setInterval(function () {

                $.ajax({
                    url: 'index.php?option=com_ajax&module=emergencyconsultant&format=json',
                    method: 'get',
                    data: {token: token},
                    success: function (msg) {

                        if (msg.data)
                        {
                            clearInterval(intervId);
                            window.location.href = window.location.href
                        }

                    }
                })
            }, 1000);
        }

        loadInformation();

        function getDateAndTimeStr(datetimeObj) {
            const dateStr = datetimeObj.toISOString().split('T')[0];
            const timeStr = datetimeObj.toTimeString().slice(0, 8);
            return {dateStr: dateStr, timeStr: timeStr};
        }

        function setDateTimeOfCountdownTimer(datetimeObj) {
            const {dateStr, timeStr} = getDateAndTimeStr(datetimeObj);
            const countdownEl = $('.countdown');
            countdownEl.data('date', dateStr);
            countdownEl.data('time', timeStr);
        }

        const newCountdownDateTime = "<?php echo $countdownDateTime; ?>";
        const oldCountdownDateTime = localStorage.getItem('countdownDateTime');
        if (!oldCountdownDateTime) {
            localStorage.setItem('countdownDateTime', newCountdownDateTime);
        } else {
            const oldCdDate = new Date(oldCountdownDateTime);
            const newCdDate = new Date(newCountdownDateTime);
            const timeDiff = (newCdDate - oldCdDate) / 1000 / 60; // Convert to minutes
            if (timeDiff < 15) { // if oldCdDate is still valid (hasn't passed 15 min since)
                setDateTimeOfCountdownTimer(oldCdDate);
            } else {
                localStorage.setItem('countdownDateTime', newCountdownDateTime);
                setDateTimeOfCountdownTimer(newCdDate);
            }
        }

    })
    
</script>