<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		doctors.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Reservation Model for Doctors
 */
class ReservationModelDoctors extends JModelList
{
	/**
	 * Model user data.
	 *
	 * @var        strings
	 */
	protected $user;
	protected $userId;
	protected $guest;
	protected $groups;
	protected $levels;
	protected $app;
	protected $input;
	protected $uikitComp;

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return      string  An SQL query
	 */
	protected function getListQuery()
	{
		// Get the current user for authorisation checks
		$this->user = JFactory::getUser();
		$this->userId = $this->user->get('id');
		$this->guest = $this->user->get('guest');
		$this->groups = $this->user->get('groups');
		$this->authorisedGroups = $this->user->getAuthorisedGroups();
		$this->levels = $this->user->getAuthorisedViewLevels();
		$this->app = JFactory::getApplication();
		$this->input = $this->app->input;
		$this->initSet = true; 
		// Get a db connection.
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);

		// Get from #__reservation_consultant as a
		$query->select($db->quoteName(
			array('a.id','a.asset_id','a.userid','a.nationalnumber','a.phonenumber','a.officephone','a.capitalid','a.cityid','a.account','a.introduction','a.msn','a.catid','a.experience','a.image','a.alt','a.video','a.presence','a.address','a.published','a.created_by','a.modified_by','a.created','a.modified','a.version','a.hits','a.ordering'),
			array('id','asset_id','userid','nationalnumber','phonenumber','officephone','capitalid','cityid','account','introduction','msn','catid','experience','image','alt','video','presence','address','published','created_by','modified_by','created','modified','version','hits','ordering')));
		$query->from($db->quoteName('#__reservation_consultant', 'a'));

		// Get from #__categories as c
		$query->select($db->quoteName(
			array('c.title'),
			array('categories_title')));
		$query->join('INNER', ($db->quoteName('#__categories', 'c')) . ' ON (' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('c.id') . ')');

		// Get from #__users as u
		$query->select($db->quoteName(
			array('u.id','u.name'),
			array('users_id','users_name')));
		$query->join('INNER', ($db->quoteName('#__users', 'u')) . ' ON (' . $db->quoteName('a.userid') . ' = ' . $db->quoteName('u.id') . ')');

		// Get from #__user_usergroup_map as uu
		$query->select($db->quoteName(
			array('uu.user_id','uu.group_id'),
			array('user_usergroup_map_user_id','user_usergroup_map_group_id')));
		$query->join('INNER', ($db->quoteName('#__user_usergroup_map', 'uu')) . ' ON (' . $db->quoteName('u.id') . ' = ' . $db->quoteName('uu.user_id') . ')');

		// Filtering.

/***[JCBGUI.dynamic_get.php_getlistquery.48.$$$$]***/
$this->params= $this->app->getparams('com_reservation');
$this->doctorGroups= empty($this->params->get('doctorgroup'))? [0]: $this->params->get('doctorgroup');

$query->where('('.$db->quoteName('a.account').'='.$db->quote('doctor').'or '.$db->quoteName('a.account').'='.$db->quote('both').')');
$query->where($db->quoteName('uu.group_id').'IN ('.implode(',',$this->doctorGroups).')');
$query->group('u.id');/***[/JCBGUI$$$$]***/


		// return the query object
		return $query;
	}

	/**
	 * Method to get an array of data items.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$user = JFactory::getUser();
		// load parent items
		$items = parent::getItems();

		// Get the global params
		$globalParams = JComponentHelper::getParams('com_reservation', true);

		// Insure all item fields are adapted where needed.
		if (ReservationHelper::checkArray($items))
		{
			// Load the JEvent Dispatcher
			JPluginHelper::importPlugin('content');
			$this->_dispatcher = JEventDispatcher::getInstance();
			foreach ($items as $nr => &$item)
			{
				// Always create a slug for sef URL's
				$item->slug = (isset($item->alias) && isset($item->id)) ? $item->id.':'.$item->alias : $item->id;
				// Check if item has params, or pass whole item.
				$params = (isset($item->params) && ReservationHelper::checkJson($item->params)) ? json_decode($item->params) : $item;
				// Make sure the content prepare plugins fire on address
				$_address = new stdClass();
				$_address->text =& $item->address; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (address) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctors.address', &$_address, &$params, 0));
				// Make sure the content prepare plugins fire on presence
				$_presence = new stdClass();
				$_presence->text =& $item->presence; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (presence) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctors.presence', &$_presence, &$params, 0));
				// Make sure the content prepare plugins fire on introduction
				$_introduction = new stdClass();
				$_introduction->text =& $item->introduction; // value must be in text
				// Since all values are now in text (Joomla Limitation), we also add the field name (introduction) to context
				$this->_dispatcher->trigger("onContentPrepare", array('com_reservation.doctors.introduction', &$_introduction, &$params, 0));
			}
		}

		// return items
		return $items;
	}
}
